/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.crypto.CryptoModuleExtender;
import org.apache.cayenne.crypto.batch.CryptoBatchTranslatorFactoryDecorator;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.cipher.DefaultCipherFactory;
import org.apache.cayenne.crypto.key.JceksKeySource;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.map.PatternColumnMapper;
import org.apache.cayenne.crypto.reader.CryptoRowReaderFactoryDecorator;
import org.apache.cayenne.crypto.transformer.DefaultTransformerFactory;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.DefaultBytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.LazyBytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.Base64StringConverter;
import org.apache.cayenne.crypto.transformer.value.BigDecimalConverter;
import org.apache.cayenne.crypto.transformer.value.BigIntegerConverter;
import org.apache.cayenne.crypto.transformer.value.BooleanConverter;
import org.apache.cayenne.crypto.transformer.value.ByteConverter;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.BytesToBytesConverter;
import org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.DoubleConverter;
import org.apache.cayenne.crypto.transformer.value.FloatConverter;
import org.apache.cayenne.crypto.transformer.value.IntegerConverter;
import org.apache.cayenne.crypto.transformer.value.LazyValueTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.LocalDateConverter;
import org.apache.cayenne.crypto.transformer.value.LocalDateTimeConverter;
import org.apache.cayenne.crypto.transformer.value.LocalTimeConverter;
import org.apache.cayenne.crypto.transformer.value.LongConverter;
import org.apache.cayenne.crypto.transformer.value.ShortConverter;
import org.apache.cayenne.crypto.transformer.value.Utf8StringConverter;
import org.apache.cayenne.crypto.transformer.value.UtilDateConverter;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;

public class CryptoModule
implements Module {
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_MODE = "CBC";
    private static final String DEFAULT_CIPHER_PADDING = "PKCS5Padding";
    private static final char[] DEFAULT_KEY_PASSWORD = "changeit".toCharArray();
    private static final String DEFAULT_COLUMN_MAPPER_PATTERN = "^CRYPTO_";

    public static CryptoModuleExtender extend() {
        return new CryptoModuleExtender();
    }

    static MapBuilder<String> contributeProperties(Binder binder) {
        return binder.bindMap(String.class, "cayenne.crypto.properties");
    }

    static MapBuilder<char[]> contributeCredentials(Binder binder) {
        return binder.bindMap(char[].class, "cayenne.crypto.properties");
    }

    static MapBuilder<BytesConverter<?>> contributeDbToByteConverters(Binder binder) {
        MapBuilder mapBuilder = binder.bindMap(BytesConverter.class, "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.dbToBytes");
        return mapBuilder;
    }

    static MapBuilder<BytesConverter<?>> contributeObjectToByteConverters(Binder binder) {
        MapBuilder mapBuilder = binder.bindMap(BytesConverter.class, "org.apache.cayenne.crypto.transformer.value.DefaultValueTransformerFactory.objectToBytes");
        return mapBuilder;
    }

    public void configure(Binder binder) {
        CryptoModule.contributeProperties(binder).put("cayenne.crypto.cipher.algorithm", (Object)DEFAULT_CIPHER_ALGORITHM).put("cayenne.crypto.cipher.mode", (Object)DEFAULT_CIPHER_MODE).put("cayenne.crypto.cipher.padding", (Object)DEFAULT_CIPHER_PADDING);
        CryptoModule.contributeCredentials(binder).put("cayenne.crypto.key.password", (Object)DEFAULT_KEY_PASSWORD);
        binder.bind(CipherFactory.class).to(DefaultCipherFactory.class);
        binder.bind(TransformerFactory.class).to(DefaultTransformerFactory.class);
        binder.bind(ValueTransformerFactory.class).to(DefaultValueTransformerFactory.class);
        MapBuilder<BytesConverter<?>> dbToBytesBinder = CryptoModule.contributeDbToByteConverters(binder);
        CryptoModule.contributeDefaultDbConverters(dbToBytesBinder);
        MapBuilder<BytesConverter<?>> objectToBytesBinder = CryptoModule.contributeObjectToByteConverters(binder);
        CryptoModule.contributeDefaultObjectConverters(objectToBytesBinder);
        binder.bind(BytesTransformerFactory.class).to(DefaultBytesTransformerFactory.class);
        binder.bind(KeySource.class).to(JceksKeySource.class);
        binder.bind(ColumnMapper.class).toInstance((Object)new PatternColumnMapper(DEFAULT_COLUMN_MAPPER_PATTERN));
        binder.decorate(BatchTranslatorFactory.class).before(CryptoBatchTranslatorFactoryDecorator.class);
        binder.bind(RowReaderFactory.class).to(CryptoRowReaderFactoryDecorator.class);
        binder.decorate(ValueTransformerFactory.class).after(LazyValueTransformerFactory.class);
        binder.decorate(BytesTransformerFactory.class).after(LazyBytesTransformerFactory.class);
    }

    private static void contributeDefaultDbConverters(MapBuilder<BytesConverter<?>> mapBuilder) {
        mapBuilder.put(String.valueOf(-2), BytesToBytesConverter.INSTANCE);
        mapBuilder.put(String.valueOf(2004), BytesToBytesConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-3), BytesToBytesConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-4), BytesToBytesConverter.INSTANCE);
        mapBuilder.put(String.valueOf(1), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-15), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(2005), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(2011), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-1), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-16), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(12), Base64StringConverter.INSTANCE);
        mapBuilder.put(String.valueOf(-9), Base64StringConverter.INSTANCE);
    }

    private static void contributeDefaultObjectConverters(MapBuilder<BytesConverter<?>> mapBuilder) {
        mapBuilder.put("byte[]", BytesToBytesConverter.INSTANCE);
        mapBuilder.put(String.class.getName(), Utf8StringConverter.INSTANCE);
        mapBuilder.put(Double.class.getName(), DoubleConverter.INSTANCE);
        mapBuilder.put(Double.TYPE.getName(), DoubleConverter.INSTANCE);
        mapBuilder.put(Float.class.getName(), FloatConverter.INSTANCE);
        mapBuilder.put(Float.TYPE.getName(), FloatConverter.INSTANCE);
        mapBuilder.put(Long.class.getName(), LongConverter.INSTANCE);
        mapBuilder.put(Long.TYPE.getName(), LongConverter.INSTANCE);
        mapBuilder.put(Integer.class.getName(), IntegerConverter.INSTANCE);
        mapBuilder.put(Integer.TYPE.getName(), IntegerConverter.INSTANCE);
        mapBuilder.put(Short.class.getName(), ShortConverter.INSTANCE);
        mapBuilder.put(Short.TYPE.getName(), ShortConverter.INSTANCE);
        mapBuilder.put(Byte.class.getName(), ByteConverter.INSTANCE);
        mapBuilder.put(Byte.TYPE.getName(), ByteConverter.INSTANCE);
        mapBuilder.put(Boolean.class.getName(), BooleanConverter.INSTANCE);
        mapBuilder.put(Boolean.TYPE.getName(), BooleanConverter.INSTANCE);
        mapBuilder.put(Date.class.getName(), UtilDateConverter.INSTANCE);
        mapBuilder.put(BigInteger.class.getName(), BigIntegerConverter.INSTANCE);
        mapBuilder.put(BigDecimal.class.getName(), BigDecimalConverter.INSTANCE);
        mapBuilder.put(LocalDate.class.getName(), LocalDateConverter.INSTANCE);
        mapBuilder.put(LocalTime.class.getName(), LocalTimeConverter.INSTANCE);
        mapBuilder.put(LocalDateTime.class.getName(), LocalDateTimeConverter.INSTANCE);
    }
}

