/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportModel;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.undo.DbImportTreeUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public abstract class TreeManipulationAction
extends CayenneAction {
    static final String EMPTY_NAME = "";
    protected DbImportTree tree;
    protected DbImportTreeNode selectedElement;
    DbImportTreeNode parentElement;
    DbImportTreeNode foundNode;
    String insertableNodeName;
    Class insertableNodeClass;
    boolean isMultipleAction;
    private boolean movedFromDbSchema;
    private Map<Class, List<Class>> levels;
    protected String name;
    protected boolean updateSelected;

    public TreeManipulationAction(String name, Application application) {
        super(name, application);
        this.initLevels();
    }

    void completeInserting(ReverseEngineering reverseEngineeringOldCopy) {
        if (!this.isMultipleAction) {
            this.updateAfterInsert();
        }
        if (!this.isMultipleAction && !this.insertableNodeName.equals(EMPTY_NAME)) {
            this.putReverseEngineeringToUndoManager(reverseEngineeringOldCopy);
        }
    }

    private String getNodeName() {
        return this.insertableNodeName != null ? this.insertableNodeName : EMPTY_NAME;
    }

    protected ReverseEngineering prepareElements() {
        this.name = this.getNodeName();
        this.tree.stopEditing();
        if (this.tree.getSelectionPath() == null) {
            TreePath root = new TreePath(this.tree.getRootNode());
            this.tree.setSelectionPath(root);
        }
        this.selectedElement = this.foundNode == null ? this.tree.getSelectedNode() : this.foundNode;
        this.parentElement = (DbImportTreeNode)this.selectedElement.getParent();
        if (this.parentElement == null) {
            this.parentElement = this.selectedElement;
        }
        if (this.reverseEngineeringIsEmpty()) {
            this.tree.getRootNode().removeAllChildren();
        }
        return new ReverseEngineering(this.tree.getReverseEngineering());
    }

    protected void putReverseEngineeringToUndoManager(ReverseEngineering reverseEngineeringOldCopy) {
        ReverseEngineering reverseEngineeringNewCopy = new ReverseEngineering(this.tree.getReverseEngineering());
        DbImportTreeUndoableEdit undoableEdit = new DbImportTreeUndoableEdit(reverseEngineeringOldCopy, reverseEngineeringNewCopy, this.tree, this.getProjectController());
        this.getProjectController().getApplication().getUndoManager().addEdit(undoableEdit);
    }

    boolean reverseEngineeringIsEmpty() {
        ReverseEngineering reverseEngineering = this.tree.getReverseEngineering();
        return reverseEngineering.getCatalogs().size() == 0 && reverseEngineering.getSchemas().size() == 0 && reverseEngineering.getIncludeTables().size() == 0 && reverseEngineering.getExcludeTables().size() == 0 && reverseEngineering.getIncludeColumns().size() == 0 && reverseEngineering.getExcludeColumns().size() == 0 && reverseEngineering.getIncludeProcedures().size() == 0 && reverseEngineering.getExcludeProcedures().size() == 0;
    }

    private void initLevels() {
        this.levels = new HashMap<Class, List<Class>>();
        ArrayList<Class<ExcludeProcedure>> rootChilds = new ArrayList<Class<ExcludeProcedure>>();
        rootChilds.add(Schema.class);
        rootChilds.add(IncludeTable.class);
        rootChilds.add(ExcludeTable.class);
        rootChilds.add(IncludeColumn.class);
        rootChilds.add(ExcludeColumn.class);
        rootChilds.add(IncludeProcedure.class);
        rootChilds.add(ExcludeProcedure.class);
        this.levels.put(ReverseEngineering.class, rootChilds);
        ArrayList<Class<ExcludeProcedure>> catalogChilds = new ArrayList<Class<ExcludeProcedure>>();
        catalogChilds.add(Schema.class);
        catalogChilds.add(IncludeTable.class);
        catalogChilds.add(ExcludeTable.class);
        catalogChilds.add(IncludeColumn.class);
        catalogChilds.add(ExcludeColumn.class);
        catalogChilds.add(IncludeProcedure.class);
        catalogChilds.add(ExcludeProcedure.class);
        this.levels.put(Catalog.class, catalogChilds);
        ArrayList<Class> schemaChilds = new ArrayList<Class>();
        schemaChilds.add(IncludeTable.class);
        schemaChilds.add(ExcludeTable.class);
        schemaChilds.add(IncludeColumn.class);
        schemaChilds.add(ExcludeColumn.class);
        schemaChilds.add(IncludeProcedure.class);
        schemaChilds.add(ExcludeProcedure.class);
        this.levels.put(Schema.class, schemaChilds);
        ArrayList<Class> includeTableChilds = new ArrayList<Class>();
        includeTableChilds.add(IncludeColumn.class);
        includeTableChilds.add(ExcludeColumn.class);
        this.levels.put(IncludeTable.class, includeTableChilds);
        this.levels.put(ExcludeTable.class, null);
        this.levels.put(IncludeColumn.class, null);
        this.levels.put(ExcludeColumn.class, null);
        this.levels.put(IncludeProcedure.class, null);
        this.levels.put(ExcludeProcedure.class, null);
    }

    public void setTree(DbImportTree tree) {
        this.tree = tree;
    }

    public JTree getTree() {
        return this.tree;
    }

    boolean canBeInserted(DbImportTreeNode node) {
        if (node == null) {
            return false;
        }
        Class<?> selectedObjectClass = node.getUserObject().getClass();
        List<Class> childs = this.levels.get(selectedObjectClass);
        return childs != null && childs.contains(this.insertableNodeClass);
    }

    boolean canInsert() {
        if (this.selectedElement == null) {
            return true;
        }
        if (this.parentElement != null) {
            for (int i = 0; i < this.parentElement.getChildCount(); ++i) {
                DbImportTreeNode child = (DbImportTreeNode)this.parentElement.getChildAt(i);
                if (!child.getSimpleNodeName().equals(this.insertableNodeName) || child.getUserObject().getClass() != this.insertableNodeClass) continue;
                return false;
            }
        }
        return true;
    }

    protected void updateModel(boolean updateSelected) {
        this.insertableNodeName = null;
        DbImportModel model = (DbImportModel)this.tree.getModel();
        this.getProjectController().setDirty(true);
        TreePath savedPath = null;
        if (!updateSelected) {
            savedPath = new TreePath(this.parentElement.getPath());
        }
        model.reload(updateSelected ? this.selectedElement : this.parentElement);
        if (savedPath != null && this.parentElement.getUserObject().getClass() != ReverseEngineering.class) {
            this.tree.setSelectionPath(savedPath);
        }
    }

    void updateAfterInsert() {
        this.updateModel(this.updateSelected);
        if (!this.movedFromDbSchema) {
            if (this.updateSelected) {
                this.tree.startEditingAtPath(new TreePath(((DbImportTreeNode)this.selectedElement.getLastChild()).getPath()));
            } else {
                this.tree.startEditingAtPath(new TreePath(((DbImportTreeNode)this.parentElement.getLastChild()).getPath()));
            }
        }
        this.resetActionFlags();
    }

    public void resetActionFlags() {
        this.movedFromDbSchema = false;
        this.isMultipleAction = false;
        this.insertableNodeName = EMPTY_NAME;
    }

    void setInsertableNodeName(String nodeName) {
        this.insertableNodeName = nodeName;
    }

    void setMultipleAction(boolean multipleAction) {
        this.isMultipleAction = multipleAction;
    }

    void setMovedFromDbSchema(boolean movedFromDbSchema) {
        this.movedFromDbSchema = movedFromDbSchema;
    }

    void setFoundNode(DbImportTreeNode node) {
        this.foundNode = node;
    }
}

