/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.util.LocalizedStringsHandler;

public class CayenneRuntimeException
extends RuntimeException {
    private static String exceptionLabel;

    public static String getExceptionLabel() {
        return exceptionLabel;
    }

    public CayenneRuntimeException() {
    }

    public CayenneRuntimeException(String messageFormat, Object ... messageArgs) {
        super(messageFormat == null ? null : String.format(messageFormat, messageArgs));
    }

    public CayenneRuntimeException(Throwable cause) {
        super(cause);
    }

    public CayenneRuntimeException(String messageFormat, Throwable cause, Object ... messageArgs) {
        super(messageFormat == null ? null : String.format(messageFormat, messageArgs), cause);
    }

    public String getUnlabeledMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        return message != null ? exceptionLabel + message : exceptionLabel + "(no message)";
    }

    static {
        String version = LocalizedStringsHandler.getString("cayenne.version");
        String date = LocalizedStringsHandler.getString("cayenne.build.date");
        exceptionLabel = "[v." + version + " " + date + "] ";
    }
}

