/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import org.apache.cayenne.modeler.undo.JTextFieldUndoListener;
import org.syntax.jedit.JEditTextArea;

class JEditTextAreaUndoable
extends JEditTextArea {
    private UndoableEditListener undoListener = new JTextFieldUndoListener(new JEditTextAreaUndoableAdapter(this));

    JEditTextAreaUndoable() {
        this.getDocument().addUndoableEditListener(this.undoListener);
    }

    @Override
    public void setText(String t) {
        this.getDocument().removeUndoableEditListener(this.undoListener);
        try {
            super.setText(t);
        }
        finally {
            this.getDocument().addUndoableEditListener(this.undoListener);
        }
    }

    private static class JEditTextAreaUndoableAdapter
    extends JTextField {
        private JEditTextArea textArea;

        @Override
        public void addFocusListener(FocusListener l) {
            if (this.textArea != null) {
                this.textArea.addFocusListener(l);
            }
        }

        public JEditTextAreaUndoableAdapter(JEditTextArea scriptArea) {
            this.textArea = scriptArea;
        }

        @Override
        public int getCaretPosition() {
            if (this.textArea == null) {
                return 0;
            }
            return this.textArea.getCaretPosition();
        }

        @Override
        public Document getDocument() {
            if (this.textArea == null) {
                return null;
            }
            return this.textArea.getDocument();
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.textArea == null) {
                return false;
            }
            return this.textArea.requestFocusInWindow();
        }

        @Override
        public void selectAll() {
            if (this.textArea == null) {
                return;
            }
            this.textArea.selectAll();
        }

        @Override
        public void setText(String t) {
            if (this.textArea == null) {
                return;
            }
            this.textArea.setText(t);
        }

        @Override
        public void setCaretPosition(int position) {
            if (this.textArea == null) {
                return;
            }
            this.textArea.setCaretPosition(position);
        }

        @Override
        public void updateUI() {
        }
    }
}

