/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbimport;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.reverse.dbimport.AntNestedElement;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;

public abstract class FilterContainer {
    private String name;
    private final Collection<IncludeTable> includeTableCollection = new LinkedList<IncludeTable>();
    private final Collection<ExcludeTable> excludeTableCollection = new LinkedList<ExcludeTable>();
    private final Collection<IncludeColumn> includeColumnCollection = new LinkedList<IncludeColumn>();
    private final Collection<ExcludeColumn> excludeColumnCollection = new LinkedList<ExcludeColumn>();
    private final Collection<IncludeProcedure> includeProcedureCollection = new LinkedList<IncludeProcedure>();
    private final Collection<ExcludeProcedure> excludeProcedureCollection = new LinkedList<ExcludeProcedure>();

    public Collection<IncludeTable> getIncludeTables() {
        return this.includeTableCollection;
    }

    public Collection<ExcludeTable> getExcludeTables() {
        return this.excludeTableCollection;
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumnCollection;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumnCollection;
    }

    public Collection<IncludeProcedure> getIncludeProcedures() {
        return this.includeProcedureCollection;
    }

    public Collection<ExcludeProcedure> getExcludeProcedures() {
        return this.excludeProcedureCollection;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumnCollection.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumnCollection.add(excludeColumn);
    }

    public void addIncludeTable(IncludeTable includeTable) {
        this.includeTableCollection.add(includeTable);
    }

    public void addExcludeTable(ExcludeTable excludeTable) {
        this.excludeTableCollection.add(excludeTable);
    }

    public void addIncludeProcedure(IncludeProcedure includeProcedure) {
        this.includeProcedureCollection.add(includeProcedure);
    }

    public void addExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.excludeProcedureCollection.add(excludeProcedure);
    }

    public void clearIncludeTables() {
        this.includeTableCollection.clear();
    }

    public void clearExcludeTables() {
        this.excludeTableCollection.clear();
    }

    public void clearIncludeProcedures() {
        this.includeProcedureCollection.clear();
    }

    public void clearExcludeProcedures() {
        this.excludeProcedureCollection.clear();
    }

    public void clearIncludeColumns() {
        this.includeColumnCollection.clear();
    }

    public void clearExcludeColumns() {
        this.excludeColumnCollection.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void set(String name) {
        this.setName(name);
    }

    public void addConfiguredName(AntNestedElement name) {
        this.setName(name.getName());
    }

    public void addText(String name) {
        if (name.trim().isEmpty()) {
            return;
        }
        this.setName(name);
    }

    public boolean isEmptyContainer() {
        return this.includeColumnCollection.isEmpty() && this.excludeColumnCollection.isEmpty() && this.includeTableCollection.isEmpty() && this.excludeTableCollection.isEmpty() && this.includeProcedureCollection.isEmpty() && this.excludeProcedureCollection.isEmpty();
    }

    static boolean isBlank(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder res, String prefix) {
        this.appendCollection(res, prefix, this.includeTableCollection);
        this.appendCollection(res, prefix, this.excludeTableCollection);
        this.appendCollection(res, prefix, this.includeColumnCollection);
        this.appendCollection(res, prefix, this.excludeColumnCollection);
        this.appendCollection(res, prefix, this.includeProcedureCollection);
        this.appendCollection(res, prefix, this.excludeProcedureCollection);
        return res;
    }

    protected void appendCollection(StringBuilder res, String prefix, Collection<? extends PatternParam> collection) {
        if (!FilterContainer.isBlank(collection)) {
            for (PatternParam patternParam : collection) {
                patternParam.toString(res, prefix);
            }
        }
    }
}

