/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.OraclePkGenerator;
import org.apache.cayenne.map.DbEntity;

public class DB2PkGenerator
extends OraclePkGenerator {
    private static final String _SEQUENCE_PREFIX = "S_";

    DB2PkGenerator(JdbcAdapter adapter) {
        super(adapter);
    }

    @Override
    protected String sequenceName(DbEntity entity) {
        return super.sequenceName(entity).toUpperCase();
    }

    @Override
    protected String getSequencePrefix() {
        return _SEQUENCE_PREFIX;
    }

    @Override
    protected String selectNextValQuery(String pkGeneratingSequenceName) {
        return "SELECT NEXTVAL FOR " + pkGeneratingSequenceName + " FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    protected String selectAllSequencesQuery() {
        return "SELECT SEQNAME FROM SYSCAT.SEQUENCES WHERE SEQNAME LIKE 'S_%'";
    }

    @Override
    protected String dropSequenceString(DbEntity entity) {
        return "DROP SEQUENCE " + this.sequenceName(entity) + " RESTRICT ";
    }

    @Override
    protected String createSequenceString(DbEntity entity) {
        return "CREATE SEQUENCE " + this.sequenceName(entity) + " AS BIGINT START WITH " + this.pkStartValue + " INCREMENT BY " + this.getPkCacheSize() + " NO MAXVALUE NO CYCLE CACHE " + this.getPkCacheSize();
    }
}

