/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;

public class ObjectSelect<T>
extends FluentSelect<T> {
    private static final long serialVersionUID = -156124021150949227L;
    protected boolean fetchingDataRows;

    public static <T> ObjectSelect<T> query(Class<T> entityType) {
        return new ObjectSelect<T>().entityType(entityType);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression) {
        return new ObjectSelect<T>().entityType(entityType).where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression, List<Ordering> orderings) {
        return new ObjectSelect<T>().entityType(entityType).where(expression).orderBy(orderings);
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType) {
        return ObjectSelect.query(entityType).fetchDataRows();
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType, Expression expression) {
        return ObjectSelect.query(entityType).fetchDataRows().where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> resultType, String entityName) {
        return new ObjectSelect<T>().entityName(entityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName, Expression expression) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName).where(expression);
    }

    public static <E> ColumnSelect<E> columnQuery(Class<?> entityType, Property<E> column) {
        return new ColumnSelect().entityType(entityType).column(column);
    }

    public static ColumnSelect<Object[]> columnQuery(Class<?> entityType, Property<?> firstColumn, Property<?> ... otherColumns) {
        return new ColumnSelect().entityType(entityType).columns(firstColumn, otherColumns);
    }

    protected ObjectSelect() {
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = (SelectQuery)super.createReplacementQuery(resolver);
        replacement.setFetchingDataRows(this.fetchingDataRows);
        return replacement;
    }

    public ObjectSelect<T> entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public ObjectSelect<T> entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public ObjectSelect<T> dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private ObjectSelect<T> resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return this;
    }

    public ObjectSelect<T> where(Expression expression) {
        return this.and(expression);
    }

    public ObjectSelect<T> where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ObjectSelect<T> and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public ObjectSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.and(all);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public ObjectSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.or(all);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public ObjectSelect<T> orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public ObjectSelect<T> orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList(orderings.size());
        }
        this.orderings.addAll(orderings);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> cacheStrategy(QueryCacheStrategy strategy) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        if (this.cacheGroup != null) {
            this.cacheGroup = null;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return this.cacheStrategy(strategy).cacheGroup(cacheGroup);
    }

    public ObjectSelect<T> cacheGroup(String cacheGroup) {
        this.cacheGroup = cacheGroup;
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public ObjectSelect<T> localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public ObjectSelect<T> sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public ObjectSelect<T> sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public ObjectSelect<DataRow> fetchDataRows() {
        if (!this.fetchingDataRows) {
            this.fetchingDataRows = true;
            this.replacementQuery = null;
        }
        return this;
    }

    public ColumnSelect<Object[]> columns(Property<?> firstProperty, Property<?> ... properties) {
        return new ColumnSelect(this).columns(firstProperty, properties);
    }

    public <E> ColumnSelect<E> column(Property<E> property) {
        return new ColumnSelect(this).column(property);
    }

    public ColumnSelect<Long> count() {
        return this.column(Property.COUNT);
    }

    public ColumnSelect<Long> count(Property<?> property) {
        return this.column(property.count());
    }

    public <E> ColumnSelect<E> min(Property<E> property) {
        return this.column(property.min());
    }

    public <E> ColumnSelect<E> max(Property<E> property) {
        return this.column(property.max());
    }

    public <E> ColumnSelect<E> avg(Property<E> property) {
        return this.column(property.avg());
    }

    public <E extends Number> ColumnSelect<E> sum(Property<E> property) {
        return this.column(property.sum());
    }

    public long selectCount(ObjectContext context) {
        return (Long)this.count().selectOne(context);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }
}

