/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache;

import com.opensymphony.oscache.base.NeedsRefreshException;
import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.query.QueryMetadata;

@Deprecated
public class OSQueryCache
implements QueryCache {
    public static final int DEFAULT_REFRESH_PERIOD = -1;
    static String DEFAULT_REFRESH_KEY = "cayenne.default.refresh";
    static String DEFAULT_CRON_KEY = "cayenne.default.cron";
    static String GROUP_PREFIX = "cayenne.group.";
    static String REFRESH_SUFFIX = ".refresh";
    static String CRON_SUFFIX = ".cron";
    protected GeneralCacheAdministrator osCache;
    RefreshSpecification defaultRefreshSpecification;
    Map<String, RefreshSpecification> refreshSpecifications;
    Properties properties;

    public OSQueryCache() {
        OSCacheAdministrator admin = new OSCacheAdministrator();
        this.init(admin, admin.getProperties());
    }

    public OSQueryCache(GeneralCacheAdministrator cache, Properties properties) {
        this.init(cache, properties);
    }

    public Collection getGroupNames() {
        return this.refreshSpecifications != null ? Collections.unmodifiableCollection(this.refreshSpecifications.keySet()) : Collections.EMPTY_SET;
    }

    public String getCronExpression(String groupName) {
        RefreshSpecification spec = null;
        if (this.refreshSpecifications != null) {
            spec = this.refreshSpecifications.get(groupName);
        }
        if (spec == null) {
            spec = this.defaultRefreshSpecification;
        }
        return spec.cronExpression;
    }

    public int getRrefreshPeriod(String groupName) {
        RefreshSpecification spec = null;
        if (this.refreshSpecifications != null) {
            spec = this.refreshSpecifications.get(groupName);
        }
        if (spec == null) {
            spec = this.defaultRefreshSpecification;
        }
        return spec.refreshPeriod;
    }

    public GeneralCacheAdministrator getOsCache() {
        return this.osCache;
    }

    public Properties getProperties() {
        return this.properties;
    }

    void init(GeneralCacheAdministrator cache, Properties properties) {
        this.properties = properties;
        this.osCache = cache;
        this.defaultRefreshSpecification = new RefreshSpecification();
        if (properties != null) {
            String defaultCron;
            String defaultRefresh = properties.getProperty(DEFAULT_REFRESH_KEY);
            if (defaultRefresh != null) {
                this.defaultRefreshSpecification.setRefreshPeriod(defaultRefresh);
            }
            if ((defaultCron = properties.getProperty(DEFAULT_CRON_KEY)) != null) {
                this.defaultRefreshSpecification.cronExpression = defaultCron;
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String name;
                String key;
                if (entry.getKey() == null || entry.getValue() == null || !(key = entry.getKey().toString()).startsWith(GROUP_PREFIX)) continue;
                if (key.endsWith(REFRESH_SUFFIX)) {
                    name = key.substring(GROUP_PREFIX.length(), key.length() - REFRESH_SUFFIX.length());
                    this.initRefreshPolicy(name, entry.getValue());
                    continue;
                }
                if (!key.endsWith(CRON_SUFFIX)) continue;
                name = key.substring(GROUP_PREFIX.length(), key.length() - CRON_SUFFIX.length());
                this.initCronPolicy(name, entry.getValue());
            }
        }
    }

    protected void initCronPolicy(String groupName, Object value) {
        this.nonNullSpec((String)groupName).cronExpression = value != null ? value.toString() : null;
    }

    protected void initRefreshPolicy(String groupName, Object value) {
        this.nonNullSpec(groupName).setRefreshPeriod(value);
    }

    private RefreshSpecification nonNullSpec(String name) {
        RefreshSpecification spec;
        if (this.refreshSpecifications == null) {
            this.refreshSpecifications = new HashMap<String, RefreshSpecification>();
        }
        if ((spec = this.refreshSpecifications.get(name)) == null) {
            spec = new RefreshSpecification();
            spec.cronExpression = this.defaultRefreshSpecification.cronExpression;
            spec.refreshPeriod = this.defaultRefreshSpecification.refreshPeriod;
            this.refreshSpecifications.put(name, spec);
        }
        return spec;
    }

    @Override
    public List get(QueryMetadata metadata) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        RefreshSpecification refresh = this.getRefreshSpecification(metadata);
        try {
            return (List)this.osCache.getFromCache(key, refresh.refreshPeriod, refresh.cronExpression);
        }
        catch (NeedsRefreshException e) {
            this.osCache.cancelUpdate(key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List get(QueryMetadata metadata, QueryCacheEntryFactory factory) {
        String key = metadata.getCacheKey();
        if (key == null) {
            return null;
        }
        RefreshSpecification refresh = this.getRefreshSpecification(metadata);
        try {
            return (List)this.osCache.getFromCache(key, refresh.refreshPeriod, refresh.cronExpression);
        }
        catch (NeedsRefreshException e) {
            boolean updated = false;
            try {
                List result = factory.createObject();
                if (result == null) {
                    throw new CayenneRuntimeException("Null on cache rebuilding: %s", metadata.getCacheKey());
                }
                this.put(metadata, result);
                updated = true;
                List list = result;
                return list;
            }
            finally {
                if (!updated) {
                    this.osCache.cancelUpdate(key);
                }
            }
        }
    }

    RefreshSpecification getRefreshSpecification(QueryMetadata metadata) {
        String group;
        RefreshSpecification refresh = null;
        if (this.refreshSpecifications != null && (group = metadata.getCacheGroup()) != null) {
            refresh = this.refreshSpecifications.get(group);
        }
        return refresh != null ? refresh : this.defaultRefreshSpecification;
    }

    @Override
    public void put(QueryMetadata metadata, List results) {
        String key = metadata.getCacheKey();
        if (key != null) {
            this.osCache.putInCache(key, (Object)results, new String[]{metadata.getCacheGroup()});
        }
    }

    @Override
    public void remove(String key) {
        if (key != null) {
            this.osCache.removeEntry(key);
        }
    }

    @Override
    public void removeGroup(String groupKey) {
        if (groupKey != null) {
            this.osCache.flushGroup(groupKey);
        }
    }

    @Override
    public void removeGroup(String groupKey, Class<?> keyType, Class<?> valueType) {
        this.removeGroup(groupKey);
    }

    @Override
    public void clear() {
        this.osCache.flushAll();
    }

    @Override
    public int size() {
        return this.osCache.getCache().getSize();
    }

    public int capacity() {
        return this.osCache.getCache().getCapacity();
    }

    @BeforeScopeEnd
    public void shutdown() {
        this.osCache.destroy();
    }

    static final class OSCacheAdministrator
    extends GeneralCacheAdministrator {
        OSCacheAdministrator() {
        }

        OSCacheAdministrator(Properties properties) {
            super(properties);
        }

        Properties getProperties() {
            return this.config.getProperties();
        }
    }

    static final class RefreshSpecification {
        int refreshPeriod;
        String cronExpression;

        RefreshSpecification() {
            this.refreshPeriod = -1;
        }

        RefreshSpecification(int refrehsPeriod, String cronExpression) {
            this.refreshPeriod = refrehsPeriod;
            this.cronExpression = cronExpression;
        }

        void setRefreshPeriod(Object value) {
            try {
                this.refreshPeriod = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

