/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.MapLoader;
import org.xml.sax.InputSource;

class CayenneGeneratorMapLoaderAction {
    private File mainDataMapFile;
    private File[] additionalDataMapFiles;
    private DataMap mainDataMap;

    CayenneGeneratorMapLoaderAction() {
    }

    DataMap getMainDataMap() throws MalformedURLException {
        if (this.mainDataMap == null) {
            MapLoader mapLoader = new MapLoader();
            DataMap mainDataMap = this.loadDataMap(mapLoader, this.mainDataMapFile);
            if (this.additionalDataMapFiles != null) {
                EntityResolver entityResolver = new EntityResolver();
                entityResolver.addDataMap(mainDataMap);
                mainDataMap.setNamespace(entityResolver);
                for (File additionalDataMapFile : this.additionalDataMapFiles) {
                    DataMap dataMap = this.loadDataMap(mapLoader, additionalDataMapFile);
                    entityResolver.addDataMap(dataMap);
                    dataMap.setNamespace(entityResolver);
                }
            }
            this.mainDataMap = mainDataMap;
        }
        return this.mainDataMap;
    }

    protected DataMap loadDataMap(MapLoader mapLoader, File dataMapFile) throws MalformedURLException {
        InputSource in = new InputSource(dataMapFile.toURL().toString());
        return mapLoader.loadDataMap(in);
    }

    void setMainDataMapFile(File mainDataMapFile) {
        this.mainDataMapFile = mainDataMapFile;
    }

    void setAdditionalDataMapFiles(File[] additionalDataMapFiles) {
        this.additionalDataMapFiles = additionalDataMapFiles;
    }
}

