/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Key<T> {
    protected Class<T> type;
    protected String typeName;
    protected String bindingName;

    public static <T> Key<T> get(Class<T> type) {
        return new Key<T>(type, null);
    }

    public static <T> Key<T> get(Class<T> type, String bindingName) {
        return new Key<T>(type, bindingName);
    }

    protected Key(Class<T> type, String bindingName) {
        if (type == null) {
            throw new NullPointerException("Null key type");
        }
        this.type = type;
        this.typeName = type.getName();
        this.bindingName = bindingName != null && bindingName.length() > 0 ? bindingName : null;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            if (!this.typeName.equals(key.typeName)) {
                return false;
            }
            if (this.bindingName != null) {
                return this.bindingName.equals(key.bindingName);
            }
            return key.bindingName == null;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 407 + 11 * this.typeName.hashCode();
        if (this.bindingName != null) {
            hashCode += this.bindingName.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<BindingKey: ");
        buffer.append(this.typeName);
        if (this.bindingName != null) {
            buffer.append(", '").append(this.bindingName).append('\'');
        }
        buffer.append('>');
        return buffer.toString();
    }
}

