/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade.v6;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.SAXNestedTagHandler;
import org.apache.cayenne.configuration.server.DBCPDataSourceFactory;
import org.apache.cayenne.configuration.server.JNDIDataSourceFactory;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.project.upgrade.v6.XMLDataMapLoader_V3_0_0_1;
import org.apache.cayenne.project.upgrade.v6.XMLDataSourceInfoLoader_V3_0_0_1;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XMLDataChannelDescriptorLoader_V3_0_0_1 {
    private static Log logger = LogFactory.getLog(XMLDataChannelDescriptorLoader_V3_0_0_1.class);
    static final String DOMAINS_TAG = "domains";
    static final String DOMAIN_TAG = "domain";
    static final String MAP_TAG = "map";
    static final String NODE_TAG = "node";
    static final String PROPERTY_TAG = "property";
    static final String MAP_REF_TAG = "map-ref";
    private static final Map<String, String> dataSourceFactoryLegacyNameMapping = new HashMap<String, String>();
    protected XMLDataMapLoader_V3_0_0_1 mapLoader = new XMLDataMapLoader_V3_0_0_1();
    protected XMLDataSourceInfoLoader_V3_0_0_1 dataSourceInfoLoader = new XMLDataSourceInfoLoader_V3_0_0_1();

    XMLDataChannelDescriptorLoader_V3_0_0_1() {
    }

    List<DataChannelDescriptor> load(Resource configurationSource) throws ConfigurationException {
        if (configurationSource == null) {
            throw new NullPointerException("Null configurationSource");
        }
        URL configurationURL = configurationSource.getURL();
        ArrayList<DataChannelDescriptor> domains = new ArrayList<DataChannelDescriptor>();
        InputStream in = null;
        try {
            in = configurationURL.openStream();
            XMLReader parser = Util.createXmlReader();
            DomainsHandler rootHandler = new DomainsHandler(configurationSource, domains, parser);
            parser.setContentHandler((ContentHandler)((Object)rootHandler));
            parser.setErrorHandler((ErrorHandler)((Object)rootHandler));
            parser.parse(new InputSource(in));
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration from %s", (Throwable)e, new Object[]{configurationURL});
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioex) {
                logger.info((Object)("failure closing input stream for " + configurationURL + ", ignoring"), (Throwable)ioex);
            }
        }
        return domains;
    }

    protected String scrubDomainName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuilder buffer = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c)) {
                buffer.append('_');
                continue;
            }
            if (i > 0 && !Character.isJavaIdentifierPart(c)) {
                buffer.append('_');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private String convertDataSourceFactory(String dataSourceFactory) {
        if (dataSourceFactory == null) {
            return null;
        }
        String converted = dataSourceFactoryLegacyNameMapping.get(dataSourceFactory);
        return converted != null ? converted : dataSourceFactory;
    }

    static {
        dataSourceFactoryLegacyNameMapping.put("org.apache.cayenne.conf.DriverDataSourceFactory", XMLPoolingDataSourceFactory.class.getName());
        dataSourceFactoryLegacyNameMapping.put("org.apache.cayenne.conf.JNDIDataSourceFactory", JNDIDataSourceFactory.class.getName());
        dataSourceFactoryLegacyNameMapping.put("org.apache.cayenne.conf.DBCPDataSourceFactory", DBCPDataSourceFactory.class.getName());
    }

    final class DataNodeChildrenHandler
    extends SAXNestedTagHandler {
        private DataNodeDescriptor nodeDescriptor;

        DataNodeChildrenHandler(XMLReader parser, SAXNestedTagHandler parentHandler, DataNodeDescriptor nodeDescriptor) {
            super(parser, parentHandler);
            this.nodeDescriptor = nodeDescriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.MAP_REF_TAG)) {
                String mapName = attributes.getValue("", "name");
                this.nodeDescriptor.getDataMapNames().add(mapName);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DataChannelChildrenHandler
    extends SAXNestedTagHandler {
        private DataChannelDescriptor descriptor;

        DataChannelChildrenHandler(DataChannelDescriptor descriptor, XMLReader parser, DomainsChildrenHandler parentHandler) {
            super(parser, (SAXNestedTagHandler)parentHandler);
            this.descriptor = descriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.PROPERTY_TAG)) {
                String key = attributes.getValue("", "name");
                String value = attributes.getValue("", "value");
                if (key != null && value != null) {
                    this.descriptor.getProperties().put(key, value);
                }
            } else if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.MAP_TAG)) {
                String dataMapName = attributes.getValue("", "name");
                Resource baseResource = this.descriptor.getConfigurationSource();
                String dataMapLocation = attributes.getValue("", "location");
                Resource dataMapResource = baseResource.getRelativeResource(dataMapLocation);
                DataMap dataMap = XMLDataChannelDescriptorLoader_V3_0_0_1.this.mapLoader.load(dataMapResource);
                dataMap.setName(dataMapName);
                dataMap.setLocation(dataMapLocation);
                dataMap.setConfigurationSource(dataMapResource);
                this.descriptor.getDataMaps().add(dataMap);
            } else if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.NODE_TAG)) {
                String nodeName = attributes.getValue("", "name");
                if (nodeName == null) {
                    throw new ConfigurationException("Error: <node> without 'name'.", new Object[0]);
                }
                DataNodeDescriptor nodeDescriptor = new DataNodeDescriptor();
                nodeDescriptor.setName(nodeName);
                String dataSourceFactory = attributes.getValue("", "factory");
                String dataSourceFactory6 = XMLDataChannelDescriptorLoader_V3_0_0_1.this.convertDataSourceFactory(dataSourceFactory);
                nodeDescriptor.setDataSourceFactoryType(dataSourceFactory6);
                String datasource = attributes.getValue("", "datasource");
                if (XMLPoolingDataSourceFactory.class.getName().equals(dataSourceFactory6)) {
                    Resource baseResource = this.descriptor.getConfigurationSource();
                    Resource dataNodeResource = baseResource.getRelativeResource(datasource);
                    nodeDescriptor.setConfigurationSource(dataNodeResource);
                    DataSourceInfo dataSourceInfo = XMLDataChannelDescriptorLoader_V3_0_0_1.this.dataSourceInfoLoader.load(dataNodeResource);
                    nodeDescriptor.setDataSourceDescriptor(dataSourceInfo);
                } else {
                    nodeDescriptor.setParameters(datasource);
                }
                this.descriptor.getNodeDescriptors().add(nodeDescriptor);
                nodeDescriptor.setAdapterType(attributes.getValue("", "adapter"));
                nodeDescriptor.setSchemaUpdateStrategyType(attributes.getValue("", "schema-update-strategy"));
                return new DataNodeChildrenHandler(this.parser, this, nodeDescriptor);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    final class DomainsChildrenHandler
    extends SAXNestedTagHandler {
        private Collection<DataChannelDescriptor> domains;
        private Resource configurationSource;

        DomainsChildrenHandler(XMLReader parser, DomainsHandler parent) {
            super(parser, (SAXNestedTagHandler)parent);
            this.domains = parent.domains;
            this.configurationSource = parent.configurationSource;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.DOMAIN_TAG)) {
                String domainName = attributes.getValue("", "name");
                DataChannelDescriptor descriptor = new DataChannelDescriptor();
                descriptor.setName(XMLDataChannelDescriptorLoader_V3_0_0_1.this.scrubDomainName(domainName));
                descriptor.setConfigurationSource(this.configurationSource);
                this.domains.add(descriptor);
                return new DataChannelChildrenHandler(descriptor, this.parser, this);
            }
            logger.info((Object)this.unexpectedTagMessage(localName, new String[]{XMLDataChannelDescriptorLoader_V3_0_0_1.DOMAIN_TAG}));
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class DomainsHandler
    extends SAXNestedTagHandler {
        private Collection<DataChannelDescriptor> domains;
        private Resource configurationSource;

        DomainsHandler(Resource configurationSource, Collection<DataChannelDescriptor> domains, XMLReader parser) {
            super(parser, null);
            this.domains = domains;
            this.configurationSource = configurationSource;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
            if (localName.equals(XMLDataChannelDescriptorLoader_V3_0_0_1.DOMAINS_TAG)) {
                return new DomainsChildrenHandler(this.parser, this);
            }
            return super.createChildTagHandler(namespaceURI, localName, qName, attributes);
        }
    }
}

