/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.SortButtonRenderer;

public class TableHeaderSortingListener
extends MouseAdapter {
    private JTableHeader header;
    private SortButtonRenderer renderer;
    private JTable table;
    private TableColumnPreferences tableColumnPreferences;

    public TableHeaderSortingListener(JTableHeader header, SortButtonRenderer renderer) {
        this.header = header;
        this.renderer = renderer;
        this.table = header.getTable();
    }

    public void mouseClicked(MouseEvent e) {
        int col = this.header.columnAtPoint(e.getPoint());
        int sortCol = this.table.convertColumnIndexToModel(col);
        if (((CayenneTableModel)this.table.getModel()).isColumnSortable(sortCol)) {
            boolean isAscent = 1 != this.renderer.getState(col);
            this.sortByDefinedColumn(col, sortCol, isAscent);
            this.tableColumnPreferences.setSortOrder(isAscent);
            this.tableColumnPreferences.setSortColumn(sortCol);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.renderer.setPressedColumn(-1);
        this.header.repaint();
    }

    public void sortByDefinedColumn(int col, int sortCol, boolean order) {
        CayenneTableModel model = (CayenneTableModel)this.table.getModel();
        if (model.isColumnSortable(sortCol)) {
            this.renderer.setPressedColumn(col);
            this.renderer.setSelectedColumn(col, order);
            this.header.repaint();
            if (this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            model.sortByColumn(sortCol, order);
        }
    }

    public void setPreferences(TableColumnPreferences tableColumnPreferences) {
        if (this.tableColumnPreferences == null) {
            this.tableColumnPreferences = tableColumnPreferences;
        }
    }
}

