/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.event.DomainListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.graph.GraphBuilder;
import org.apache.cayenne.modeler.graph.GraphMap;
import org.apache.cayenne.modeler.graph.GraphType;
import org.jgraph.JGraph;

public class GraphRegistry
implements DomainListener {
    Map<DataChannelDescriptor, GraphMap> graphMaps = new HashMap<DataChannelDescriptor, GraphMap>();

    public JGraph loadGraph(ProjectController mediator, DataChannelDescriptor domain, GraphType type) {
        GraphBuilder builder;
        GraphMap graphMap = this.graphMaps.get(domain);
        if (graphMap == null) {
            graphMap = new GraphMap(domain);
            this.graphMaps.put(domain, graphMap);
        }
        if ((builder = (GraphBuilder)graphMap.get((Object)type)) == null) {
            builder = graphMap.createGraphBuilder(type, true);
            mediator.setDirty(true);
        }
        graphMap.setSelectedType(builder.getType());
        return builder.getGraph();
    }

    public GraphMap getGraphMap(DataChannelDescriptor domain) {
        GraphMap map = this.graphMaps.get(domain);
        if (map == null) {
            map = new GraphMap(domain);
            this.graphMaps.put(domain, map);
        }
        return map;
    }

    public void domainChanged(DomainEvent e) {
    }

    void unregisterDomain(DataChannelDescriptor dataChannelDescriptor) {
        GraphMap map = this.graphMaps.get(dataChannelDescriptor);
        if (map != null) {
            for (GraphBuilder builder : map.values()) {
                builder.destroy();
            }
            this.graphMaps.remove(dataChannelDescriptor);
        }
    }

    public void unregister(ProjectController mediator) {
        this.unregisterDomain((DataChannelDescriptor)mediator.getProject().getRootNode());
        mediator.removeDomainListener(this);
    }
}

