/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.cassandra.sidecar.utils.DigestAlgorithm;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;

public class JdkMd5DigestProvider
implements DigestAlgorithmProvider {
    @Override
    public DigestAlgorithm get(int seed) {
        return new JdkMD5Digest();
    }

    public static class JdkMD5Digest
    implements DigestAlgorithm {
        private final MessageDigest md5;

        public JdkMD5Digest() {
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void update(byte[] buf, int off, int len) {
            this.md5.update(buf, off, len);
        }

        @Override
        public String digest() {
            return Base64.getEncoder().encodeToString(this.md5.digest());
        }

        @Override
        public void close() {
        }
    }
}

