/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class SSTableImportMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.SSTableImport";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<DefaultSettableGauge<Integer>> pendingImports;
    public final NamedMetric<DeltaGauge> successfulImports;
    public final NamedMetric<DeltaGauge> failedImports;

    public SSTableImportMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.pendingImports = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("PendingImports").build();
        this.successfulImports = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("SuccessfulImports").build();
        this.failedImports = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("FailedImports").build();
    }
}

