/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.sstableuploads;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Meter;
import com.datastax.driver.core.KeyspaceMetadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.response.SSTableUploadResponse;
import org.apache.cassandra.sidecar.concurrent.ConcurrencyLimiter;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.concurrent.TaskExecutorPool;
import org.apache.cassandra.sidecar.config.SSTableUploadConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.data.SSTableUploadRequestParam;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.instance.InstanceMetrics;
import org.apache.cassandra.sidecar.metrics.instance.InstanceResourceMetrics;
import org.apache.cassandra.sidecar.metrics.instance.UploadSSTableMetrics;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.DigestVerifier;
import org.apache.cassandra.sidecar.utils.DigestVerifierFactory;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.MetadataUtils;
import org.apache.cassandra.sidecar.utils.MetricUtils;
import org.apache.cassandra.sidecar.utils.SSTableUploader;
import org.apache.cassandra.sidecar.utils.SSTableUploadsPathBuilder;
import org.jetbrains.annotations.NotNull;

@Singleton
public class SSTableUploadHandler
extends AbstractHandler<SSTableUploadRequestParam>
implements AccessProtected {
    private final FileSystem fs;
    private final SSTableUploadConfiguration configuration;
    private final SSTableUploader uploader;
    private final SSTableUploadsPathBuilder uploadPathBuilder;
    private final ConcurrencyLimiter limiter;
    private final DigestVerifierFactory digestVerifierFactory;

    @Inject
    protected SSTableUploadHandler(Vertx vertx, ServiceConfiguration serviceConfiguration, InstanceMetadataFetcher metadataFetcher, SSTableUploader uploader, SSTableUploadsPathBuilder uploadPathBuilder, ExecutorPools executorPools, CassandraInputValidator validator, DigestVerifierFactory digestVerifierFactory) {
        super(metadataFetcher, executorPools, validator);
        this.fs = vertx.fileSystem();
        this.configuration = serviceConfiguration.sstableUploadConfiguration();
        this.uploader = uploader;
        this.uploadPathBuilder = uploadPathBuilder;
        this.limiter = new ConcurrencyLimiter(this.configuration::concurrentUploadsLimit);
        this.digestVerifierFactory = digestVerifierFactory;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.UPLOAD_STAGED_SSTABLE.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, SSTableUploadRequestParam request) {
        httpRequest.pause();
        InstanceMetrics instanceMetrics = this.metadataFetcher.instance(host).metrics();
        UploadSSTableMetrics.UploadSSTableComponentMetrics componentMetrics = instanceMetrics.uploadSSTable().forComponent(MetricUtils.parseSSTableComponent(request.component()));
        long startTimeInNanos = System.nanoTime();
        if (!this.limiter.tryAcquire()) {
            String message = String.format("Concurrent upload limit (%d) exceeded", this.limiter.limit());
            ((DeltaGauge)instanceMetrics.uploadSSTable().throttled.metric).update(1L);
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.TOO_MANY_REQUESTS, message));
            return;
        }
        context.addEndHandler(v -> this.limiter.releasePermit());
        this.validateKeyspaceAndTable(host, request).compose(validRequest -> this.uploadPathBuilder.resolveStagingDirectory(host)).compose(uploadDir -> this.ensureSufficientSpaceAvailable((String)uploadDir, instanceMetrics.resource())).compose(v -> this.uploadPathBuilder.build(host, request)).compose(uploadDirectory -> {
            DigestVerifier digestVerifier = this.digestVerifierFactory.verifier(httpRequest.headers());
            return this.uploader.uploadComponent((ReadStream<Buffer>)httpRequest, (String)uploadDirectory, request.component(), digestVerifier, this.configuration.filePermissions());
        }).compose(arg_0 -> ((FileSystem)this.fs).props(arg_0)).onSuccess(fileProps -> {
            long serviceTimeMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeInNanos);
            this.logger.info("Successfully uploaded SSTable component for request={}, remoteAddress={}, instance={}, sizeInBytes={}, serviceTimeMillis={}", new Object[]{request, remoteAddress, host, fileProps.size(), serviceTimeMillis});
            ((Meter)componentMetrics.bytesUploadedRate.metric).mark(fileProps.size());
            ((Meter)instanceMetrics.uploadSSTable().totalBytesUploadedRate.metric).mark(fileProps.size());
            context.json((Object)new SSTableUploadResponse(request.uploadId(), fileProps.size(), serviceTimeMillis));
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, SSTableUploadRequestParam request) {
        if (cause instanceof IllegalArgumentException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, cause.getMessage(), cause));
        } else {
            super.processFailure(cause, context, host, remoteAddress, request);
        }
    }

    @Override
    protected SSTableUploadRequestParam extractParamsOrThrow(RoutingContext context) {
        return SSTableUploadRequestParam.from(this.qualifiedTableName(context, true), context);
    }

    private Future<SSTableUploadRequestParam> validateKeyspaceAndTable(String host, SSTableUploadRequestParam request) {
        TaskExecutorPool pool = this.executorPools.service();
        return pool.executeBlocking(() -> this.metadataFetcher.delegate(host).metadata()).compose(metadata -> {
            KeyspaceMetadata keyspaceMetadata = MetadataUtils.keyspace(metadata, request.keyspace());
            if (keyspaceMetadata == null) {
                String message = String.format("Invalid keyspace '%s' supplied", request.keyspace());
                this.logger.error(message);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, message));
            }
            if (MetadataUtils.table(keyspaceMetadata, request.table()) == null) {
                String message = String.format("Invalid table name '%s' supplied for keyspace '%s'", request.table(), request.keyspace());
                this.logger.error(message);
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, message));
            }
            return Future.succeededFuture((Object)request);
        });
    }

    private Future<String> ensureSufficientSpaceAvailable(String uploadDirectory, InstanceResourceMetrics resourceMetrics) {
        float minimumPercentageRequired = this.configuration.minimumSpacePercentageRequired();
        if (minimumPercentageRequired == 0.0f) {
            return Future.succeededFuture((Object)uploadDirectory);
        }
        return this.fs.fsProps(uploadDirectory).compose(fsProps -> {
            long totalSpace = fsProps.totalSpace();
            long usableSpace = fsProps.usableSpace();
            ((DefaultSettableGauge)resourceMetrics.usableStagingSpace.metric).setValue((Object)usableSpace);
            double spacePercentAvailable = usableSpace > 0L && totalSpace > 0L ? (double)usableSpace / (double)totalSpace * 100.0 : 0.0;
            return Future.succeededFuture((Object)spacePercentAvailable);
        }).compose(availableDiskSpacePercentage -> {
            if (availableDiskSpacePercentage < (double)minimumPercentageRequired) {
                this.logger.warn("Insufficient space available for upload in stagingDir={}, available={}%, required={}%", new Object[]{uploadDirectory, availableDiskSpacePercentage, Float.valueOf(minimumPercentageRequired)});
                return Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.INSUFFICIENT_STORAGE, "Insufficient space available for upload"));
            }
            return Future.succeededFuture((Object)uploadDirectory);
        });
    }
}

