/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.livemigration;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.config.LiveMigrationConfiguration;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.handlers.livemigration.LiveMigrationMap;
import org.jetbrains.annotations.NotNull;

@Singleton
public class LiveMigrationMapSidecarConfigImpl
implements LiveMigrationMap {
    private final LiveMigrationConfiguration liveMigrationConfiguration;

    @Inject
    public LiveMigrationMapSidecarConfigImpl(SidecarConfiguration sidecarConfiguration) {
        this.liveMigrationConfiguration = sidecarConfiguration.liveMigrationConfiguration();
    }

    @Override
    public boolean isSource(@NotNull InstanceMetadata instanceMeta) {
        return this.liveMigrationConfiguration.migrationMap().containsKey(instanceMeta.host());
    }

    @Override
    public boolean isDestination(@NotNull InstanceMetadata instanceMeta) {
        return this.liveMigrationConfiguration.migrationMap().containsValue(instanceMeta.host());
    }

    @Override
    public Map<String, String> getMigrationMap() {
        return this.liveMigrationConfiguration.migrationMap();
    }
}

