/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.cdc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.db.ConfigAccessor;
import org.apache.cassandra.sidecar.db.ConfigAccessorFactory;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.cdc.ServiceConfigValidator;

@Singleton
public class UpdateServiceConfigHandler
implements Handler<RoutingContext>,
AccessProtected {
    private final ConfigAccessorFactory configAccessorFactory;
    private final ServiceConfigValidator serviceConfigValidator;

    @Inject
    public UpdateServiceConfigHandler(ConfigAccessorFactory configAccessorFactory, ServiceConfigValidator serviceConfigValidator) {
        this.configAccessorFactory = configAccessorFactory;
        this.serviceConfigValidator = serviceConfigValidator;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CDC.toAuthorization());
    }

    public void handle(RoutingContext context) {
        String serviceName = context.pathParam("service");
        Service service = this.serviceConfigValidator.validateAndGet(serviceName);
        JsonObject payload = context.body().asJsonObject();
        this.serviceConfigValidator.validatePayload(payload);
        this.serviceConfigValidator.validateConfig(payload);
        ConfigAccessor accessor = this.configAccessorFactory.configAccessor(service);
        Map<String, String> config = payload.getJsonObject("config").getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        accessor.storeConfig(config);
        context.json((Object)payload);
    }
}

