/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.KeyspaceMetadata;
import com.linkedin.common.BrowsePathEntry;
import com.linkedin.common.BrowsePathEntryArray;
import com.linkedin.common.BrowsePathsV2;
import com.linkedin.data.template.SetMode;
import datahub.event.MetadataChangeProposalWrapper;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.KeyspaceToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class KeyspaceToBrowsePathsV2Converter
extends KeyspaceToAspectConverter<BrowsePathsV2> {
    public KeyspaceToBrowsePathsV2Converter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<BrowsePathsV2> convert(@NotNull KeyspaceMetadata keyspace) {
        String urn = this.identifiers.urnContainer(keyspace);
        BrowsePathsV2 aspect = new BrowsePathsV2().setPath(new BrowsePathEntryArray(new BrowsePathEntry().setId(this.identifiers.environment()).setUrn(null, SetMode.REMOVE_IF_NULL), new BrowsePathEntry[]{new BrowsePathEntry().setId(this.identifiers.application()).setUrn(null, SetMode.REMOVE_IF_NULL), new BrowsePathEntry().setId(this.identifiers.cluster()).setUrn(null, SetMode.REMOVE_IF_NULL)}));
        return this.wrap(urn, aspect);
    }
}

