/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.sidecar.config.CassandraInputValidationConfiguration;

public class CassandraInputValidationConfigurationImpl
implements CassandraInputValidationConfiguration {
    public static final String FORBIDDEN_KEYSPACES_PROPERTY = "forbidden_keyspaces";
    public static final Set<String> DEFAULT_FORBIDDEN_KEYSPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("system_schema", "system_traces", "system_distributed", "system", "system_auth", "system_views", "system_virtual_schema", "sidecar_internal")));
    public static final String ALLOWED_CHARS_FOR_NAME_PROPERTY = "allowed_chars_for_directory";
    public static final String DEFAULT_ALLOWED_CHARS_FOR_NAME = "[a-zA-Z][a-zA-Z0-9_]{0,47}";
    public static final String ALLOWED_CHARS_FOR_QUOTED_NAME_PROPERTY = "allowed_chars_for_quoted_name";
    public static final String DEFAULT_ALLOWED_CHARS_FOR_QUOTED_NAME = "[a-zA-Z_0-9]{1,48}";
    public static final String ALLOWED_CHARS_FOR_COMPONENT_NAME_PROPERTY = "allowed_chars_for_component_name";
    public static final String DEFAULT_ALLOWED_CHARS_FOR_COMPONENT_NAME = "[a-zA-Z0-9_-]+(.db|.cql|.json|.crc32|TOC.txt)";
    public static final String ALLOWED_CHARS_FOR_RESTRICTED_COMPONENT_NAME_PROPERTY = "allowed_chars_for_restricted_component_name";
    public static final String DEFAULT_ALLOWED_CHARS_FOR_RESTRICTED_COMPONENT_NAME = "[a-zA-Z0-9_-]+(.db|TOC.txt)";
    @JsonProperty(value="forbidden_keyspaces")
    protected final Set<String> forbiddenKeyspaces;
    @JsonProperty(value="allowed_chars_for_directory")
    protected final String allowedPatternForName;
    @JsonProperty(value="allowed_chars_for_quoted_name")
    protected final String allowedPatternForQuotedName;
    @JsonProperty(value="allowed_chars_for_component_name")
    protected final String allowedPatternForComponentName;
    @JsonProperty(value="allowed_chars_for_restricted_component_name")
    protected final String allowedPatternForRestrictedComponentName;

    public CassandraInputValidationConfigurationImpl() {
        this(DEFAULT_FORBIDDEN_KEYSPACES, DEFAULT_ALLOWED_CHARS_FOR_NAME, DEFAULT_ALLOWED_CHARS_FOR_QUOTED_NAME, DEFAULT_ALLOWED_CHARS_FOR_COMPONENT_NAME, DEFAULT_ALLOWED_CHARS_FOR_RESTRICTED_COMPONENT_NAME);
    }

    public CassandraInputValidationConfigurationImpl(Set<String> forbiddenKeyspaces, String allowedPatternForName, String allowedPatternForQuotedName, String allowedPatternForComponentName, String allowedPatternForRestrictedComponentName) {
        this.forbiddenKeyspaces = forbiddenKeyspaces;
        this.allowedPatternForName = allowedPatternForName;
        this.allowedPatternForQuotedName = allowedPatternForQuotedName;
        this.allowedPatternForComponentName = allowedPatternForComponentName;
        this.allowedPatternForRestrictedComponentName = allowedPatternForRestrictedComponentName;
    }

    @Override
    @JsonProperty(value="forbidden_keyspaces")
    public Set<String> forbiddenKeyspaces() {
        return this.forbiddenKeyspaces;
    }

    @Override
    @JsonProperty(value="allowed_chars_for_directory")
    public String allowedPatternForName() {
        return this.allowedPatternForName;
    }

    @Override
    @JsonProperty(value="allowed_chars_for_quoted_name")
    public String allowedPatternForQuotedName() {
        return this.allowedPatternForQuotedName;
    }

    @Override
    @JsonProperty(value="allowed_chars_for_component_name")
    public String allowedPatternForComponentName() {
        return this.allowedPatternForComponentName;
    }

    @Override
    @JsonProperty(value="allowed_chars_for_restricted_component_name")
    public String allowedPatternForRestrictedComponentName() {
        return this.allowedPatternForRestrictedComponentName;
    }
}

