/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.cluster;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.cluster.ConsistencyVerifier;
import org.apache.cassandra.sidecar.cluster.locator.InstanceSetByDc;
import org.apache.cassandra.sidecar.common.data.ConsistencyLevel;
import org.apache.cassandra.sidecar.common.data.ConsistencyVerificationResult;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsistencyVerifiers {
    private static final String UNKNOWN_DC = "ConsistencyVerifiers.UnknownDc";

    private ConsistencyVerifiers() {
        throw new UnsupportedOperationException();
    }

    public static ConsistencyVerifier forConsistencyLevel(ConsistencyLevel consistencyLevel) {
        Preconditions.checkArgument((!consistencyLevel.isLocalDcOnly ? 1 : 0) != 0, (String)"Cannot create verifier with local consistency level");
        return ConsistencyVerifiers.forConsistencyLevel(consistencyLevel, null);
    }

    public static ConsistencyVerifier forConsistencyLevel(ConsistencyLevel consistencyLevel, @Nullable String localDatacenter) {
        switch (consistencyLevel) {
            case ONE: {
                return ForOne.INSTANCE;
            }
            case TWO: {
                return ForTwo.INSTANCE;
            }
            case QUORUM: {
                return ForQuorum.INSTANCE;
            }
            case ALL: {
                return ForAll.INSTANCE;
            }
            case EACH_QUORUM: {
                return ForEachQuorum.INSTANCE;
            }
            case LOCAL_ONE: {
                return new ForLocalOne(localDatacenter);
            }
            case LOCAL_QUORUM: {
                return new ForLocalQuorum(localDatacenter);
            }
        }
        throw new IllegalStateException("Encountered unknown consistency level: " + consistencyLevel);
    }

    private static abstract class BaseLocalDcVerifier
    extends BaseVerifier {
        protected final String localDatacenter;

        BaseLocalDcVerifier(String localDatacenter) {
            Preconditions.checkArgument((localDatacenter != null && !localDatacenter.isEmpty() ? 1 : 0) != 0, (String)"localDatacenter must present for local DC consistency verifier");
            this.localDatacenter = localDatacenter;
        }

        @Override
        public ConsistencyVerificationResult verify(@NotNull Set<String> succeeded, @NotNull Set<String> failed, @NotNull InstanceSetByDc all) {
            Preconditions.checkArgument((boolean)all.containsDatacenter(this.localDatacenter), (String)("Parameter 'all' should contain the local datacenter: " + this.localDatacenter));
            Set<String> localReplicas = all.get(this.localDatacenter);
            InstanceSetByDc localAll = new InstanceSetByDc(this.localDatacenter, localReplicas);
            InstanceSetByDc localPassed = this.filterByDc(succeeded, this.localDatacenter, localReplicas::contains);
            InstanceSetByDc localFailed = this.filterByDc(failed, this.localDatacenter, localReplicas::contains);
            return this.verifyForLocalDC(localPassed, localFailed, localAll);
        }

        protected abstract ConsistencyVerificationResult verifyForLocalDC(InstanceSetByDc var1, InstanceSetByDc var2, InstanceSetByDc var3);
    }

    public static class ForLocalQuorum
    extends BaseLocalDcVerifier {
        ForLocalQuorum(String localDatacenter) {
            super(localDatacenter);
        }

        @Override
        protected ConsistencyVerificationResult verifyForLocalDC(InstanceSetByDc localPassed, InstanceSetByDc localFailed, InstanceSetByDc localAll) {
            if (this.geQuorum(this.sum(localPassed), this.sum(localAll))) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (this.geQuorum(this.sum(localFailed), this.sum(localAll))) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForLocalOne
    extends BaseLocalDcVerifier {
        ForLocalOne(String localDatacenter) {
            super(localDatacenter);
        }

        @Override
        protected ConsistencyVerificationResult verifyForLocalDC(InstanceSetByDc localPassed, InstanceSetByDc localFailed, InstanceSetByDc localAll) {
            if (this.sum(localPassed) > 0) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (this.sum(localFailed) == this.sum(localAll)) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForAll
    extends BaseVerifier {
        public static final ForAll INSTANCE = new ForAll();

        @Override
        public ConsistencyVerificationResult verify(Set<String> succeeded, Set<String> failed, InstanceSetByDc all) {
            if (succeeded.size() == this.sum(all)) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (!failed.isEmpty()) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForQuorum
    extends BaseVerifier {
        public static final ForQuorum INSTANCE = new ForQuorum();

        @Override
        public ConsistencyVerificationResult verify(Set<String> succeeded, Set<String> failed, InstanceSetByDc all) {
            if (this.geQuorum(succeeded.size(), this.sum(all))) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (this.geQuorum(failed.size(), this.sum(all))) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForEachQuorum
    extends BaseVerifier {
        public static final ForEachQuorum INSTANCE = new ForEachQuorum();

        @Override
        public ConsistencyVerificationResult verify(Set<String> succeeded, Set<String> failed, InstanceSetByDc all) {
            HashMap dcByInstance = new HashMap(this.sum(all));
            all.forEach((dcName, replicaSet) -> replicaSet.forEach(instance -> dcByInstance.put(instance, dcName)));
            UnaryOperator dcClassifier = s -> {
                String dc = (String)dcByInstance.get(s);
                return dc != null ? dc : ConsistencyVerifiers.UNKNOWN_DC;
            };
            InstanceSetByDc passedByDc = this.groupByDc(succeeded, dcClassifier);
            this.validateNoneFromUnknownDc(passedByDc, "passed");
            InstanceSetByDc failedByDc = this.groupByDc(failed, dcClassifier);
            this.validateNoneFromUnknownDc(failedByDc, "failed");
            boolean allSatisfied = true;
            boolean anyFailed = false;
            for (String dcName2 : all.keySet()) {
                if (!this.geQuorum(passedByDc.get(dcName2).size(), all.get(dcName2).size())) {
                    allSatisfied = false;
                }
                if (!this.geQuorum(failedByDc.get(dcName2).size(), all.get(dcName2).size())) continue;
                anyFailed = true;
            }
            if (allSatisfied) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (anyFailed) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForTwo
    extends BaseVerifier {
        public static final ForTwo INSTANCE = new ForTwo();

        @Override
        public ConsistencyVerificationResult verify(Set<String> succeeded, Set<String> failed, InstanceSetByDc all) {
            if (succeeded.size() >= 2) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (failed.size() == this.sum(all) - 1) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static class ForOne
    extends BaseVerifier {
        public static final ForOne INSTANCE = new ForOne();

        @Override
        public ConsistencyVerificationResult verify(Set<String> succeeded, Set<String> failed, InstanceSetByDc all) {
            if (!succeeded.isEmpty()) {
                return ConsistencyVerificationResult.SATISFIED;
            }
            if (failed.size() == this.sum(all)) {
                return ConsistencyVerificationResult.FAILED;
            }
            return ConsistencyVerificationResult.PENDING;
        }
    }

    public static abstract class BaseVerifier
    implements ConsistencyVerifier {
        protected int quorum(int total) {
            return total / 2 + 1;
        }

        protected int sum(InstanceSetByDc instanceSetByDc) {
            return instanceSetByDc.mapping.values().stream().mapToInt(Set::size).sum();
        }

        protected boolean geQuorum(int count, int total) {
            return count >= this.quorum(total);
        }

        protected InstanceSetByDc groupByDc(Set<String> instances, UnaryOperator<String> dcClassifier) {
            return new InstanceSetByDc(instances.stream().collect(Collectors.groupingBy(dcClassifier, Collectors.toSet())));
        }

        protected InstanceSetByDc filterByDc(Set<String> instances, String dcName, Predicate<String> dcFilter) {
            Set<String> localDcInstances = instances.stream().filter(dcFilter).collect(Collectors.toSet());
            return new InstanceSetByDc(dcName, localDcInstances);
        }

        protected void validateNoneFromUnknownDc(InstanceSetByDc instanceSetByDc, String kind) {
            if (instanceSetByDc.mapping.containsKey(ConsistencyVerifiers.UNKNOWN_DC)) {
                throw new IllegalStateException("Instances from the " + kind + " set belongs to unknown datacenter. Instances: " + instanceSetByDc.mapping.get(ConsistencyVerifiers.UNKNOWN_DC));
            }
        }
    }
}

