/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import io.netty.handler.codec.http.HttpMethod;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.UploadableRequest;
import org.apache.cassandra.sidecar.common.request.data.Digest;

public class UploadSSTableRequest
extends Request
implements UploadableRequest {
    private final Digest digest;
    private final String filename;

    public UploadSSTableRequest(String keyspace, String table, String uploadId, String component, Digest digest, String filename) {
        super(UploadSSTableRequest.requestURI(keyspace, table, uploadId, component));
        this.digest = digest;
        this.filename = Objects.requireNonNull(filename, "the filename is must be non-null");
        if (!Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException("File '" + filename + "' does not exist");
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    @Override
    public Map<String, String> headers() {
        if (this.digest == null) {
            return super.headers();
        }
        HashMap<String, String> headers = new HashMap<String, String>(super.headers());
        headers.putAll(this.digest.headers());
        return Collections.unmodifiableMap(headers);
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.PUT;
    }

    static String requestURI(String keyspace, String tableName, String uploadId, String component) {
        return "/api/v1/uploads/:uploadId/keyspaces/:keyspace/tables/:table/components/:component".replaceAll(":uploadId", uploadId).replaceAll(":keyspace", keyspace).replaceAll(":table", tableName).replaceAll(":component", component);
    }
}

