/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.posix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.openhft.posix.Mapping;

public final class ProcMaps {
    private final List<Mapping> mappingList = new ArrayList<Mapping>();

    private ProcMaps(Object proc) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/" + proc + "/maps"));){
            String line;
            while ((line = br.readLine()) != null) {
                this.mappingList.add(new Mapping(line));
            }
        }
    }

    public static ProcMaps forSelf() throws IOException {
        return new ProcMaps("self");
    }

    public static ProcMaps forPID(int pid) throws IOException {
        return new ProcMaps(pid);
    }

    public List<Mapping> list() {
        return Collections.unmodifiableList(this.mappingList);
    }

    public Mapping findFirst(Predicate<? super Mapping> test) {
        return this.mappingList.stream().filter(test).findFirst().get();
    }

    public List<Mapping> findAll(Predicate<? super Mapping> test) {
        return this.mappingList.stream().filter(test).collect(Collectors.toList());
    }
}

