/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Arrays;

public final class SHA1Spi
extends MessageDigestSpi
implements Cloneable {
    private static final String HASH_NAME = "SHA-1";
    private static final int HASH_SIZE;
    private static final byte[] INITIAL_CONTEXT;
    private InputBuffer<byte[], byte[], RuntimeException> buffer;

    static native void fastDigest(byte[] var0, byte[] var1, int var2);

    private static native int getHashSize();

    private static native int getContextSize();

    private static native void initContext(byte[] var0);

    private static native void updateContextByteArray(byte[] var0, byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedUpdateContextByteArray(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3 = byArray;
        synchronized (byArray) {
            SHA1Spi.updateContextByteArray(byArray, byArray2, n, n2);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static native void updateNativeByteBuffer(byte[] var0, ByteBuffer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedUpdateNativeByteBuffer(byte[] byArray, ByteBuffer byteBuffer) {
        byte[] byArray2 = byArray;
        synchronized (byArray) {
            SHA1Spi.updateNativeByteBuffer(byArray, byteBuffer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static native void finish(byte[] var0, byte[] var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void synchronizedFinish(byte[] byArray, byte[] byArray2, int n) {
        byte[] byArray3 = byArray;
        synchronized (byArray) {
            SHA1Spi.finish(byArray, byArray2, n);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static byte[] resetContext(byte[] byArray) {
        if (byArray == null) {
            byArray = (byte[])INITIAL_CONTEXT.clone();
        } else {
            System.arraycopy(INITIAL_CONTEXT, 0, byArray, 0, INITIAL_CONTEXT.length);
        }
        return byArray;
    }

    private static byte[] doFinal(byte[] byArray) {
        byte[] byArray2 = new byte[HASH_SIZE];
        SHA1Spi.synchronizedFinish(byArray, byArray2, 0);
        return byArray2;
    }

    private static byte[] singlePass(byte[] byArray, int n, int n2) {
        if (n != 0 || n2 != byArray.length) {
            byArray = Arrays.copyOf(byArray, n2);
            n = 0;
        }
        byte[] byArray2 = new byte[HASH_SIZE];
        SHA1Spi.fastDigest(byArray2, byArray, byArray.length);
        return byArray2;
    }

    public SHA1Spi() {
        Loader.checkNativeLibraryAvailability();
        this.buffer = new InputBuffer(1024).withInitialStateSupplier(SHA1Spi::resetContext).withUpdater(SHA1Spi::synchronizedUpdateContextByteArray).withUpdater(SHA1Spi::synchronizedUpdateNativeByteBuffer).withDoFinal(SHA1Spi::doFinal).withSinglePass(SHA1Spi::singlePass).withStateCloner(byArray -> (byte[])byArray.clone());
    }

    @Override
    protected void engineUpdate(byte by) {
        this.buffer.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.update(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.update(byteBuffer);
    }

    @Override
    protected int engineGetDigestLength() {
        return HASH_SIZE;
    }

    @Override
    public Object clone() {
        try {
            SHA1Spi sHA1Spi = (SHA1Spi)super.clone();
            sHA1Spi.buffer = this.buffer.clone();
            return sHA1Spi;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Unexpected CloneNotSupportedException", cloneNotSupportedException);
        }
    }

    @Override
    protected byte[] engineDigest() {
        try {
            byte[] byArray = this.buffer.doFinal();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < HASH_SIZE) {
            throw new IllegalArgumentException("Buffer length too small");
        }
        byte[] byArray2 = this.engineDigest();
        try {
            System.arraycopy(byArray2, 0, byArray, n, HASH_SIZE);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(arrayIndexOutOfBoundsException);
        }
        return HASH_SIZE;
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    static {
        Loader.checkNativeLibraryAvailability();
        INITIAL_CONTEXT = new byte[SHA1Spi.getContextSize()];
        SHA1Spi.initContext(INITIAL_CONTEXT);
        HASH_SIZE = SHA1Spi.getHashSize();
    }
}

