/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.EvpEcPrivateKey;
import com.amazon.corretto.crypto.provider.EvpEcPublicKey;
import com.amazon.corretto.crypto.provider.EvpRsaPrivateCrtKey;
import com.amazon.corretto.crypto.provider.EvpRsaPublicKey;
import com.amazon.corretto.crypto.provider.MiscInterfaces;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum EvpKeyType {
    RSA("RSA", 6, RSAPublicKey.class, RSAPrivateKey.class),
    EC("EC", 408, ECPublicKey.class, ECPrivateKey.class);

    final String jceName;
    final int nativeValue;
    final Class<? extends PublicKey> publicKeyClass;
    final Class<? extends PrivateKey> privateKeyClass;
    private static final Map<String, EvpKeyType> jceNameMapping;

    private EvpKeyType(String string2, int n2, Class<? extends PublicKey> clazz, Class<? extends PrivateKey> clazz2) {
        this.jceName = string2;
        this.nativeValue = n2;
        this.publicKeyClass = clazz;
        this.privateKeyClass = clazz2;
    }

    static EvpKeyType fromJceName(String string) {
        return jceNameMapping.get(string);
    }

    <X extends Throwable> PrivateKey buildPrivateKey(MiscInterfaces.ThrowingToLongBiFunction<byte[], Integer, X> throwingToLongBiFunction, PKCS8EncodedKeySpec pKCS8EncodedKeySpec) throws X {
        switch (this) {
            case RSA: {
                return EvpRsaPrivateCrtKey.buildProperKey(throwingToLongBiFunction.applyAsLong(pKCS8EncodedKeySpec.getEncoded(), this.nativeValue));
            }
            case EC: {
                return new EvpEcPrivateKey(throwingToLongBiFunction.applyAsLong(pKCS8EncodedKeySpec.getEncoded(), this.nativeValue));
            }
        }
        throw new AssertionError((Object)"Unsupported key type");
    }

    <X extends Throwable> PublicKey buildPublicKey(MiscInterfaces.ThrowingToLongBiFunction<byte[], Integer, X> throwingToLongBiFunction, X509EncodedKeySpec x509EncodedKeySpec) throws X {
        switch (this) {
            case RSA: {
                return new EvpRsaPublicKey(throwingToLongBiFunction.applyAsLong(x509EncodedKeySpec.getEncoded(), this.nativeValue));
            }
            case EC: {
                return new EvpEcPublicKey(throwingToLongBiFunction.applyAsLong(x509EncodedKeySpec.getEncoded(), this.nativeValue));
            }
        }
        throw new AssertionError((Object)"Unsupported key type");
    }

    static {
        jceNameMapping = new HashMap<String, EvpKeyType>();
        for (EvpKeyType evpKeyType : EnumSet.allOf(EvpKeyType.class)) {
            jceNameMapping.put(evpKeyType.jceName, evpKeyType);
        }
    }
}

