/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="invalidatecidrpermissionscache", description="Invalidate the cidr permissions cache")
public class InvalidateCIDRPermissionsCache
extends NodeTool.NodeToolCmd {
    @Arguments(usage="[<role>...]", description="List of roles to invalidate. By default, all roles")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        if (this.args.isEmpty()) {
            probe.invalidateCidrPermissionsCache("");
            probe.output().out.println("Invalidated CIDR permissions cache");
        } else {
            for (String roleName : this.args) {
                if (probe.invalidateCidrPermissionsCache(roleName)) {
                    probe.output().out.println("Invalidated the role " + roleName + " from CIDR permissions cache");
                    continue;
                }
                probe.output().out.println("Not found role " + roleName + " in CIDR permissions cache, nothing to invalidate");
            }
        }
    }
}

