/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.cassandra.auth.AuthCacheMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getauthcacheconfig", description="Get configuration of Auth cache")
public class GetAuthCacheConfig
extends NodeTool.NodeToolCmd {
    @Option(title="cache-name", name={"--cache-name"}, description="Name of Auth cache (required)", required=true)
    private String cacheName;

    @Override
    public void execute(NodeProbe probe) {
        AuthCacheMBean authCacheMBean = probe.getAuthCacheMBean(this.cacheName);
        probe.output().out.println("Validity Period: " + authCacheMBean.getValidity());
        probe.output().out.println("Update Interval: " + authCacheMBean.getUpdateInterval());
        probe.output().out.println("Max Entries: " + authCacheMBean.getMaxEntries());
        probe.output().out.println("Active Update: " + authCacheMBean.getActiveUpdate());
    }
}

