/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.restrictions.StatementRestrictions;
import org.apache.cassandra.cql3.selection.Selection;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.transport.messages.ResultMessage;

public class ClientRequestSizeMetrics {
    private static final String TYPE = "ClientRequestSize";
    public static final Counter totalColumnsRead = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("ClientRequestSize", "ColumnsRead", null));
    public static final Counter totalRowsRead = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("ClientRequestSize", "RowsRead", null));
    public static final Counter totalColumnsWritten = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("ClientRequestSize", "ColumnsWritten", null));
    public static final Counter totalRowsWritten = CassandraMetricsRegistry.Metrics.counter(DefaultNameFactory.createMetricName("ClientRequestSize", "RowsWritten", null));

    public static void recordReadResponseMetrics(ResultMessage.Rows rows, StatementRestrictions restrictions, Selection selection) {
        if (!DatabaseDescriptor.getClientRequestSizeMetricsEnabled()) {
            return;
        }
        int rowCount = rows.result.size();
        totalRowsRead.inc((long)rowCount);
        int nonRestrictedColumns = selection.getColumns().size();
        for (ColumnMetadata column : selection.getColumns()) {
            if (!restrictions.isEqualityRestricted(column)) continue;
            --nonRestrictedColumns;
        }
        long columnCount = (long)rowCount * (long)nonRestrictedColumns;
        totalColumnsRead.inc(columnCount);
    }

    public static void recordRowAndColumnCountMetrics(Collection<? extends IMutation> mutations) {
        if (!DatabaseDescriptor.getClientRequestSizeMetricsEnabled()) {
            return;
        }
        int rowCount = 0;
        int columnCount = 0;
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                columnCount += update.affectedColumnCount();
                rowCount += update.affectedRowCount();
            }
        }
        totalColumnsWritten.inc((long)columnCount);
        totalRowsWritten.inc((long)rowCount);
    }

    public static void recordRowAndColumnCountMetrics(PartitionUpdate update) {
        if (!DatabaseDescriptor.getClientRequestSizeMetricsEnabled()) {
            return;
        }
        totalColumnsWritten.inc((long)update.affectedColumnCount());
        totalRowsWritten.inc((long)update.affectedRowCount());
    }
}

