/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnitchProperties {
    private static final Logger logger = LoggerFactory.getLogger(SnitchProperties.class);
    public static final String RACKDC_PROPERTY_FILENAME = CassandraRelevantProperties.CASSANDRA_RACKDC_PROPERTIES.getKey();
    private final Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnitchProperties() {
        this.properties = new Properties();
        InputStream stream = null;
        String configURL = CassandraRelevantProperties.CASSANDRA_RACKDC_PROPERTIES.getString();
        try {
            URL url = configURL == null ? SnitchProperties.class.getClassLoader().getResource(RACKDC_PROPERTY_FILENAME) : new URL(configURL);
            stream = url.openStream();
            this.properties.load(stream);
        }
        catch (Exception e) {
            try {
                logger.warn("Unable to read {}", (Object)(configURL != null ? configURL : RACKDC_PROPERTY_FILENAME));
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(stream);
                throw throwable;
            }
            FileUtils.closeQuietly(stream);
        }
        FileUtils.closeQuietly(stream);
    }

    @VisibleForTesting
    public SnitchProperties(Properties properties) {
        this.properties = properties;
    }

    @SafeVarargs
    public SnitchProperties(Pair<String, String> ... pairs) {
        this.properties = new Properties();
        for (Pair<String, String> pair : pairs) {
            this.properties.setProperty((String)pair.left, (String)pair.right);
        }
    }

    public String get(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public SnitchProperties add(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public SnitchProperties putIfAbsent(String key, String value) {
        if (this.contains(key)) {
            return this;
        }
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.properties);
        p.put(key, value);
        return new SnitchProperties(p);
    }

    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public String getDcSuffix() {
        return this.properties.getProperty("dc_suffix", "");
    }

    public String toString() {
        return "SnitchProperties{properties=" + (this.properties != null ? this.properties.toString() : "null") + "}";
    }
}

