/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bitpack;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.format.IndexDescriptor;
import org.apache.cassandra.index.sai.disk.v1.MetadataWriter;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bitpack.AbstractBlockPackedWriter;
import org.apache.cassandra.index.sai.disk.v1.bitpack.BlockPackedWriter;
import org.apache.cassandra.index.sai.disk.v1.bitpack.MonotonicBlockPackedWriter;
import org.apache.cassandra.index.sai.disk.v1.bitpack.NumericValuesMeta;
import org.apache.lucene.store.IndexOutput;

@NotThreadSafe
public class NumericValuesWriter
implements Closeable {
    public static final int MONOTONIC_BLOCK_SIZE = 16384;
    public static final int BLOCK_SIZE = 128;
    private final IndexOutput indexOutput;
    private final AbstractBlockPackedWriter writer;
    private final MetadataWriter metadataWriter;
    private final String componentName;
    private final int blockSize;
    private long count = 0L;

    public NumericValuesWriter(IndexDescriptor indexDescriptor, IndexComponent indexComponent, MetadataWriter metadataWriter, boolean monotonic) throws IOException {
        this(indexDescriptor, indexComponent, metadataWriter, monotonic, monotonic ? 16384 : 128);
    }

    public NumericValuesWriter(IndexDescriptor indexDescriptor, IndexComponent indexComponent, MetadataWriter metadataWriter, boolean monotonic, int blockSize) throws IOException {
        this.componentName = indexDescriptor.componentName(indexComponent);
        this.indexOutput = indexDescriptor.openPerSSTableOutput(indexComponent);
        SAICodecUtils.writeHeader(this.indexOutput);
        this.writer = monotonic ? new MonotonicBlockPackedWriter(this.indexOutput, blockSize) : new BlockPackedWriter(this.indexOutput, blockSize);
        this.metadataWriter = metadataWriter;
        this.blockSize = blockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try (MetadataWriter.Builder o = this.metadataWriter.builder(this.componentName);){
            long fp = this.writer.finish();
            SAICodecUtils.writeFooter(this.indexOutput);
            NumericValuesMeta.write(o, this.count, this.blockSize, fp);
        }
        finally {
            this.indexOutput.close();
        }
    }

    public void add(long value) throws IOException {
        this.writer.add(value);
        ++this.count;
    }
}

