/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai;

import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.exceptions.QueryCancelledException;
import org.apache.cassandra.index.sai.VectorQueryContext;
import org.apache.cassandra.utils.Clock;

@NotThreadSafe
public class QueryContext {
    private static final boolean DISABLE_TIMEOUT = CassandraRelevantProperties.SAI_TEST_DISABLE_TIMEOUT.getBoolean();
    private final ReadCommand readCommand;
    private final long queryStartTimeNanos;
    public final long executionQuotaNano;
    public long sstablesHit = 0L;
    public long segmentsHit = 0L;
    public long partitionsRead = 0L;
    public long rowsFiltered = 0L;
    public long trieSegmentsHit = 0L;
    public long triePostingsSkips = 0L;
    public long triePostingsDecodes = 0L;
    public long balancedTreePostingListsHit = 0L;
    public long balancedTreeSegmentsHit = 0L;
    public long balancedTreePostingsSkips = 0L;
    public long balancedTreePostingsDecodes = 0L;
    public boolean queryTimedOut = false;
    public boolean hasUnrepairedMatches = false;
    private VectorQueryContext vectorContext;

    public QueryContext(ReadCommand readCommand, long executionQuotaMs) {
        this.readCommand = readCommand;
        this.executionQuotaNano = TimeUnit.MILLISECONDS.toNanos(executionQuotaMs);
        this.queryStartTimeNanos = Clock.Global.nanoTime();
    }

    public long totalQueryTimeNs() {
        return Clock.Global.nanoTime() - this.queryStartTimeNanos;
    }

    public void checkpoint() {
        if (this.totalQueryTimeNs() >= this.executionQuotaNano && !DISABLE_TIMEOUT) {
            this.queryTimedOut = true;
            throw new QueryCancelledException(this.readCommand);
        }
    }

    public VectorQueryContext vectorContext() {
        if (this.vectorContext == null) {
            this.vectorContext = new VectorQueryContext(this.readCommand);
        }
        return this.vectorContext;
    }
}

