/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.schema.CreateTableStatement;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogPosition;
import org.apache.cassandra.db.compaction.CompactionHistoryTabularData;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SequenceBasedSSTableId;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.metrics.TopPartitionTracker;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.schema.UserFunctions;
import org.apache.cassandra.schema.Views;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosRepairHistory;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.uncommitted.PaxosRows;
import org.apache.cassandra.service.paxos.uncommitted.PaxosUncommittedIndex;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MD5Digest;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SystemKeyspace.class);
    public static final CassandraVersion CURRENT_VERSION = new CassandraVersion(FBUtilities.getReleaseVersionString());
    public static final String BATCHES = "batches";
    public static final String PAXOS = "paxos";
    public static final String PAXOS_REPAIR_HISTORY = "paxos_repair_history";
    public static final String PAXOS_REPAIR_STATE = "_paxos_repair_state";
    public static final String BUILT_INDEXES = "IndexInfo";
    public static final String LOCAL = "local";
    public static final String PEERS_V2 = "peers_v2";
    public static final String PEER_EVENTS_V2 = "peer_events_v2";
    public static final String COMPACTION_HISTORY = "compaction_history";
    public static final String SSTABLE_ACTIVITY_V2 = "sstable_activity_v2";
    public static final String TABLE_ESTIMATES = "table_estimates";
    public static final String TABLE_ESTIMATES_TYPE_PRIMARY = "primary";
    public static final String TABLE_ESTIMATES_TYPE_LOCAL_PRIMARY = "local_primary";
    public static final String AVAILABLE_RANGES_V2 = "available_ranges_v2";
    public static final String TRANSFERRED_RANGES_V2 = "transferred_ranges_v2";
    public static final String VIEW_BUILDS_IN_PROGRESS = "view_builds_in_progress";
    public static final String BUILT_VIEWS = "built_views";
    public static final String PREPARED_STATEMENTS = "prepared_statements";
    public static final String REPAIRS = "repairs";
    public static final String TOP_PARTITIONS = "top_partitions";
    public static final Set<String> TABLES_SPLIT_ACROSS_MULTIPLE_DISKS = ImmutableSet.of((Object)"batches", (Object)"paxos", (Object)"compaction_history", (Object)"prepared_statements", (Object)"repairs");
    @Deprecated(since="4.0")
    public static final String LEGACY_PEERS = "peers";
    @Deprecated(since="4.0")
    public static final String LEGACY_PEER_EVENTS = "peer_events";
    @Deprecated(since="4.0")
    public static final String LEGACY_TRANSFERRED_RANGES = "transferred_ranges";
    @Deprecated(since="4.0")
    public static final String LEGACY_AVAILABLE_RANGES = "available_ranges";
    @Deprecated(since="4.0")
    public static final String LEGACY_SIZE_ESTIMATES = "size_estimates";
    @Deprecated(since="4.1")
    public static final String LEGACY_SSTABLE_ACTIVITY = "sstable_activity";
    public static final Set<String> ALL_TABLE_NAMES = ImmutableSet.of((Object)"batches", (Object)"paxos", (Object)"paxos_repair_history", (Object)"_paxos_repair_state", (Object)"IndexInfo", (Object)"local", (Object[])new String[]{"peers_v2", "peer_events_v2", "compaction_history", "sstable_activity_v2", "table_estimates", "primary", "local_primary", "available_ranges_v2", "transferred_ranges_v2", "view_builds_in_progress", "built_views", "prepared_statements", "repairs", "top_partitions", "peers", "peer_events", "transferred_ranges", "available_ranges", "size_estimates", "sstable_activity"});
    public static final Set<String> TABLE_NAMES = ImmutableSet.of((Object)"batches", (Object)"paxos", (Object)"paxos_repair_history", (Object)"IndexInfo", (Object)"local", (Object)"peers_v2", (Object[])new String[]{"peer_events_v2", "compaction_history", "sstable_activity_v2", "table_estimates", "available_ranges_v2", "transferred_ranges_v2", "view_builds_in_progress", "built_views", "prepared_statements", "repairs", "top_partitions", "peers", "peer_events", "transferred_ranges", "available_ranges", "size_estimates", "sstable_activity"});
    public static final TableMetadata Batches = SystemKeyspace.parse("batches", "batches awaiting replay", "CREATE TABLE %s (id timeuuid,mutations list<blob>,version int,PRIMARY KEY ((id)))").partitioner(new LocalPartitioner(TimeUUIDType.instance)).compaction(CompactionParams.stcs(Collections.singletonMap("min_threshold", "2"))).build();
    private static final TableMetadata Paxos = SystemKeyspace.parse("paxos", "in-progress paxos proposals", "CREATE TABLE %s (row_key blob,cf_id UUID,in_progress_ballot timeuuid,in_progress_read_ballot timeuuid,most_recent_commit blob,most_recent_commit_at timeuuid,most_recent_commit_version int,proposal blob,proposal_ballot timeuuid,proposal_version int,PRIMARY KEY ((row_key), cf_id))").compaction(CompactionParams.lcs(Collections.emptyMap())).indexes(PaxosUncommittedIndex.indexes()).build();
    private static final TableMetadata BuiltIndexes = SystemKeyspace.parse("IndexInfo", "built column indexes", "CREATE TABLE \"%s\" (table_name text,index_name text,value blob,PRIMARY KEY ((table_name), index_name)) ").build();
    private static final TableMetadata PaxosRepairHistoryTable = SystemKeyspace.parse("paxos_repair_history", "paxos repair history", "CREATE TABLE %s (keyspace_name text,table_name text,points frozen<list<tuple<blob, timeuuid>>>, PRIMARY KEY (keyspace_name, table_name))WITH COMMENT='Last successful paxos repairs by range'").build();
    private static final TableMetadata Local = SystemKeyspace.parse("local", "information about the local node", "CREATE TABLE %s (key text,bootstrapped text,broadcast_address inet,broadcast_port int,cluster_name text,cql_version text,data_center text,gossip_generation int,host_id uuid,listen_address inet,listen_port int,native_protocol_version text,partitioner text,rack text,release_version text,rpc_address inet,rpc_port int,schema_version uuid,tokens set<varchar>,truncated_at map<uuid, blob>,PRIMARY KEY ((key)))").recordDeprecatedSystemColumn("thrift_version", UTF8Type.instance).build();
    private static final TableMetadata PeersV2 = SystemKeyspace.parse("peers_v2", "information about known peers in the cluster", "CREATE TABLE %s (peer inet,peer_port int,data_center text,host_id uuid,preferred_ip inet,preferred_port int,rack text,release_version text,native_address inet,native_port int,schema_version uuid,tokens set<varchar>,PRIMARY KEY ((peer), peer_port))").build();
    private static final TableMetadata PeerEventsV2 = SystemKeyspace.parse("peer_events_v2", "events related to peers", "CREATE TABLE %s (peer inet,peer_port int,hints_dropped map<timeuuid, int>,PRIMARY KEY ((peer), peer_port))").build();
    private static final TableMetadata CompactionHistory = SystemKeyspace.parse("compaction_history", "week-long compaction history", "CREATE TABLE %s (id timeuuid,bytes_in bigint,bytes_out bigint,columnfamily_name text,compacted_at timestamp,keyspace_name text,rows_merged map<int, bigint>,compaction_properties frozen<map<text, text>>,PRIMARY KEY ((id)))").defaultTimeToLive((int)TimeUnit.DAYS.toSeconds(7L)).build();
    private static final TableMetadata LegacySSTableActivity = SystemKeyspace.parse("sstable_activity", "historic sstable read rates", "CREATE TABLE %s (keyspace_name text,columnfamily_name text,generation int,rate_120m double,rate_15m double,PRIMARY KEY ((keyspace_name, columnfamily_name, generation)))").build();
    private static final TableMetadata SSTableActivity = SystemKeyspace.parse("sstable_activity_v2", "historic sstable read rates", "CREATE TABLE %s (keyspace_name text,table_name text,id text,rate_120m double,rate_15m double,PRIMARY KEY ((keyspace_name, table_name, id)))").build();
    @Deprecated(since="4.0")
    private static final TableMetadata LegacySizeEstimates = SystemKeyspace.parse("size_estimates", "per-table primary range size estimates, table is deprecated in favor of table_estimates", "CREATE TABLE %s (keyspace_name text,table_name text,range_start text,range_end text,mean_partition_size bigint,partitions_count bigint,PRIMARY KEY ((keyspace_name), table_name, range_start, range_end))").build();
    private static final TableMetadata TableEstimates = SystemKeyspace.parse("table_estimates", "per-table range size estimates", "CREATE TABLE %s (keyspace_name text,table_name text,range_type text,range_start text,range_end text,mean_partition_size bigint,partitions_count bigint,PRIMARY KEY ((keyspace_name), table_name, range_type, range_start, range_end))").build();
    private static final TableMetadata AvailableRangesV2 = SystemKeyspace.parse("available_ranges_v2", "available keyspace/ranges during bootstrap/replace that are ready to be served", "CREATE TABLE %s (keyspace_name text,full_ranges set<blob>,transient_ranges set<blob>,PRIMARY KEY ((keyspace_name)))").build();
    private static final TableMetadata TransferredRangesV2 = SystemKeyspace.parse("transferred_ranges_v2", "record of transferred ranges for streaming operation", "CREATE TABLE %s (operation text,peer inet,peer_port int,keyspace_name text,ranges set<blob>,PRIMARY KEY ((operation, keyspace_name), peer, peer_port))").build();
    private static final TableMetadata ViewBuildsInProgress = SystemKeyspace.parse("view_builds_in_progress", "views builds current progress", "CREATE TABLE %s (keyspace_name text,view_name text,start_token varchar,end_token varchar,last_token varchar,keys_built bigint,PRIMARY KEY ((keyspace_name), view_name, start_token, end_token))").build();
    private static final TableMetadata BuiltViews = SystemKeyspace.parse("built_views", "built views", "CREATE TABLE %s (keyspace_name text,view_name text,status_replicated boolean,PRIMARY KEY ((keyspace_name), view_name))").build();
    private static final TableMetadata TopPartitions = SystemKeyspace.parse("top_partitions", "Stores the top partitions", "CREATE TABLE  %s (keyspace_name text,table_name text,top_type text,top frozen<list<tuple<text, bigint>>>,last_update timestamp,PRIMARY KEY (keyspace_name, table_name, top_type))").build();
    private static final TableMetadata PreparedStatements = SystemKeyspace.parse("prepared_statements", "prepared statements", "CREATE TABLE %s (prepared_id blob,logged_keyspace text,query_string text,PRIMARY KEY ((prepared_id)))").build();
    private static final TableMetadata Repairs = SystemKeyspace.parse("repairs", "repairs", "CREATE TABLE %s (parent_id timeuuid, started_at timestamp, last_update timestamp, repaired_at timestamp, state int, coordinator inet, coordinator_port int,participants set<inet>,participants_wp set<text>,ranges set<blob>, cfids set<uuid>, PRIMARY KEY (parent_id))").build();
    @Deprecated(since="4.0")
    private static final TableMetadata LegacyPeers = SystemKeyspace.parse("peers", "information about known peers in the cluster", "CREATE TABLE %s (peer inet,data_center text,host_id uuid,preferred_ip inet,rack text,release_version text,rpc_address inet,schema_version uuid,tokens set<varchar>,PRIMARY KEY ((peer)))").build();
    @Deprecated(since="4.0")
    private static final TableMetadata LegacyPeerEvents = SystemKeyspace.parse("peer_events", "events related to peers", "CREATE TABLE %s (peer inet,hints_dropped map<timeuuid, int>,PRIMARY KEY ((peer)))").build();
    @Deprecated(since="4.0")
    private static final TableMetadata LegacyTransferredRanges = SystemKeyspace.parse("transferred_ranges", "record of transferred ranges for streaming operation", "CREATE TABLE %s (operation text,peer inet,keyspace_name text,ranges set<blob>,PRIMARY KEY ((operation, keyspace_name), peer))").build();
    @Deprecated(since="4.0")
    private static final TableMetadata LegacyAvailableRanges = SystemKeyspace.parse("available_ranges", "available keyspace/ranges during bootstrap/replace that are ready to be served", "CREATE TABLE %s (keyspace_name text,ranges set<blob>,PRIMARY KEY ((keyspace_name)))").build();
    private static volatile Map<TableId, Pair<CommitLogPosition, Long>> truncationRecords;

    private SystemKeyspace() {
    }

    private static TableMetadata.Builder parse(String table, String description, String cql) {
        return CreateTableStatement.parse(String.format(cql, table), "system").id(TableId.forSystemTable("system", table)).gcGraceSeconds(0).memtableFlushPeriod((int)TimeUnit.HOURS.toMillis(1L)).comment(description);
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create("system", KeyspaceParams.local(), SystemKeyspace.tables(), Views.none(), Types.none(), UserFunctions.none());
    }

    private static Tables tables() {
        return Tables.of(BuiltIndexes, Batches, Paxos, PaxosRepairHistoryTable, Local, PeersV2, LegacyPeers, PeerEventsV2, LegacyPeerEvents, CompactionHistory, LegacySSTableActivity, SSTableActivity, LegacySizeEstimates, TableEstimates, AvailableRangesV2, LegacyAvailableRanges, TransferredRangesV2, LegacyTransferredRanges, ViewBuildsInProgress, BuiltViews, PreparedStatements, Repairs, TopPartitions);
    }

    public static void persistLocalMetadata() {
        SystemKeyspace.persistLocalMetadata(UUID::randomUUID);
    }

    @VisibleForTesting
    public static void persistLocalMetadata(Supplier<UUID> nodeIdSupplier) {
        String req = "INSERT INTO system.%s (key,cluster_name,release_version,cql_version,native_protocol_version,data_center,rack,partitioner,rpc_address,rpc_port,broadcast_address,broadcast_port,listen_address,listen_port) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        QueryProcessor.executeOnceInternal(String.format(req, LOCAL), LOCAL, DatabaseDescriptor.getClusterName(), FBUtilities.getReleaseVersionString(), QueryProcessor.CQL_VERSION.toString(), String.valueOf(ProtocolVersion.CURRENT.asInt()), snitch.getLocalDatacenter(), snitch.getLocalRack(), DatabaseDescriptor.getPartitioner().getClass().getName(), FBUtilities.getJustBroadcastNativeAddress(), DatabaseDescriptor.getNativeTransportPort(), FBUtilities.getJustBroadcastAddress(), DatabaseDescriptor.getStoragePort(), FBUtilities.getJustLocalAddress(), DatabaseDescriptor.getStoragePort());
        if (!CommitLog.instance.hasFilesToReplay()) {
            SystemKeyspace.getOrInitializeLocalHostId(nodeIdSupplier);
        }
    }

    public static void updateCompactionHistory(TimeUUID taskId, String ksname, String cfname, long compactedAt, long bytesIn, long bytesOut, Map<Integer, Long> rowsMerged, Map<String, String> compactionProperties) {
        if (ksname.equals("system") && cfname.equals(COMPACTION_HISTORY)) {
            return;
        }
        String req = "INSERT INTO system.%s (id, keyspace_name, columnfamily_name, compacted_at, bytes_in, bytes_out, rows_merged, compaction_properties) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, COMPACTION_HISTORY), taskId, ksname, cfname, ByteBufferUtil.bytes(compactedAt), bytesIn, bytesOut, rowsMerged, compactionProperties);
    }

    public static TabularData getCompactionHistory() throws OpenDataException {
        UntypedResultSet queryResultSet = QueryProcessor.executeInternal(String.format("SELECT * from system.%s", COMPACTION_HISTORY), new Object[0]);
        return CompactionHistoryTabularData.from(queryResultSet);
    }

    public static boolean isViewBuilt(String keyspaceName, String viewName) {
        String req = "SELECT view_name FROM %s.\"%s\" WHERE keyspace_name=? AND view_name=?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "system", BUILT_VIEWS), keyspaceName, viewName);
        return !result.isEmpty();
    }

    public static boolean isViewStatusReplicated(String keyspaceName, String viewName) {
        String req = "SELECT status_replicated FROM %s.\"%s\" WHERE keyspace_name=? AND view_name=?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "system", BUILT_VIEWS), keyspaceName, viewName);
        if (result.isEmpty()) {
            return false;
        }
        UntypedResultSet.Row row = result.one();
        return row.has("status_replicated") && row.getBoolean("status_replicated");
    }

    public static void setViewBuilt(String keyspaceName, String viewName, boolean replicated) {
        if (SystemKeyspace.isViewBuilt(keyspaceName, viewName) && SystemKeyspace.isViewStatusReplicated(keyspaceName, viewName) == replicated) {
            return;
        }
        String req = "INSERT INTO %s.\"%s\" (keyspace_name, view_name, status_replicated) VALUES (?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, "system", BUILT_VIEWS), keyspaceName, viewName, replicated);
        SystemKeyspace.forceBlockingFlush(BUILT_VIEWS);
    }

    public static void setViewRemoved(String keyspaceName, String viewName) {
        String buildReq = "DELETE FROM %s.%s WHERE keyspace_name = ? AND view_name = ?";
        QueryProcessor.executeInternal(String.format(buildReq, "system", VIEW_BUILDS_IN_PROGRESS), keyspaceName, viewName);
        String builtReq = "DELETE FROM %s.\"%s\" WHERE keyspace_name = ? AND view_name = ? IF EXISTS";
        QueryProcessor.executeInternal(String.format(builtReq, "system", BUILT_VIEWS), keyspaceName, viewName);
        SystemKeyspace.forceBlockingFlush(VIEW_BUILDS_IN_PROGRESS, BUILT_VIEWS);
    }

    public static void finishViewBuildStatus(String ksname, String viewName) {
        SystemKeyspace.setViewBuilt(ksname, viewName, false);
        QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE keyspace_name = ? AND view_name = ?", VIEW_BUILDS_IN_PROGRESS), ksname, viewName);
        SystemKeyspace.forceBlockingFlush(VIEW_BUILDS_IN_PROGRESS);
    }

    public static void setViewBuiltReplicated(String ksname, String viewName) {
        SystemKeyspace.setViewBuilt(ksname, viewName, true);
    }

    public static void updateViewBuildStatus(String ksname, String viewName, Range<Token> range, Token lastToken, long keysBuilt) {
        String req = "INSERT INTO system.%s (keyspace_name, view_name, start_token, end_token, last_token, keys_built) VALUES (?, ?, ?, ?, ?, ?)";
        Token.TokenFactory factory = SystemKeyspace.ViewBuildsInProgress.partitioner.getTokenFactory();
        QueryProcessor.executeInternal(String.format(req, VIEW_BUILDS_IN_PROGRESS), ksname, viewName, factory.toString((Token)range.left), factory.toString((Token)range.right), factory.toString(lastToken), keysBuilt);
    }

    public static Map<Range<Token>, Pair<Token, Long>> getViewBuildStatus(String ksname, String viewName) {
        String req = "SELECT start_token, end_token, last_token, keys_built FROM system.%s WHERE keyspace_name = ? AND view_name = ?";
        Token.TokenFactory factory = SystemKeyspace.ViewBuildsInProgress.partitioner.getTokenFactory();
        UntypedResultSet rs = QueryProcessor.executeInternal(String.format(req, VIEW_BUILDS_IN_PROGRESS), ksname, viewName);
        if (rs == null || rs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Range<Token>, Pair<Token, Long>> status = new HashMap<Range<Token>, Pair<Token, Long>>();
        for (UntypedResultSet.Row row : rs) {
            Token start = factory.fromString(row.getString("start_token"));
            Token end = factory.fromString(row.getString("end_token"));
            Range<Token> range = new Range<Token>(start, end);
            Token lastToken = row.has("last_token") ? factory.fromString(row.getString("last_token")) : null;
            long keysBuilt = row.has("keys_built") ? row.getLong("keys_built") : 0L;
            status.put(range, Pair.create(lastToken, keysBuilt));
        }
        return status;
    }

    public static synchronized void saveTruncationRecord(ColumnFamilyStore cfs, long truncatedAt, CommitLogPosition position) {
        String req = "UPDATE system.%s SET truncated_at = truncated_at + ? WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), SystemKeyspace.truncationAsMapEntry(cfs, truncatedAt, position));
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static synchronized void removeTruncationRecord(TableId id) {
        Pair<CommitLogPosition, Long> truncationRecord = SystemKeyspace.getTruncationRecord(id);
        if (truncationRecord == null) {
            return;
        }
        String req = "DELETE truncated_at[?] from system.%s WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), id.asUUID());
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    private static Map<UUID, ByteBuffer> truncationAsMapEntry(ColumnFamilyStore cfs, long truncatedAt, CommitLogPosition position) {
        DataOutputBuffer out = (DataOutputBuffer)DataOutputBuffer.scratchBuffer.get();
        try {
            CommitLogPosition.serializer.serialize(position, (DataOutputPlus)out);
            out.writeLong(truncatedAt);
            Map<UUID, ByteBuffer> map = Collections.singletonMap(cfs.metadata.id.asUUID(), out.asNewBuffer());
            if (out != null) {
                out.close();
            }
            return map;
        }
        catch (Throwable throwable) {
            try {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static CommitLogPosition getTruncatedPosition(TableId id) {
        Pair<CommitLogPosition, Long> record = SystemKeyspace.getTruncationRecord(id);
        return record == null ? null : (CommitLogPosition)record.left;
    }

    public static long getTruncatedAt(TableId id) {
        Pair<CommitLogPosition, Long> record = SystemKeyspace.getTruncationRecord(id);
        return record == null ? Long.MIN_VALUE : (Long)record.right;
    }

    private static synchronized Pair<CommitLogPosition, Long> getTruncationRecord(TableId id) {
        if (truncationRecords == null) {
            truncationRecords = SystemKeyspace.readTruncationRecords();
        }
        return truncationRecords.get(id);
    }

    private static Map<TableId, Pair<CommitLogPosition, Long>> readTruncationRecords() {
        UntypedResultSet rows = QueryProcessor.executeInternal(String.format("SELECT truncated_at FROM system.%s WHERE key = '%s'", LOCAL, LOCAL), new Object[0]);
        HashMap<TableId, Pair<CommitLogPosition, Long>> records = new HashMap<TableId, Pair<CommitLogPosition, Long>>();
        if (!rows.isEmpty() && rows.one().has("truncated_at")) {
            Map<UUID, ByteBuffer> map = rows.one().getMap("truncated_at", UUIDType.instance, BytesType.instance);
            for (Map.Entry<UUID, ByteBuffer> entry : map.entrySet()) {
                records.put(TableId.fromUUID(entry.getKey()), SystemKeyspace.truncationRecordFromBlob(entry.getValue()));
            }
        }
        return records;
    }

    private static Pair<CommitLogPosition, Long> truncationRecordFromBlob(ByteBuffer bytes) {
        Pair<CommitLogPosition, Long> pair;
        DataInputBuffer in = new DataInputBuffer(bytes, true);
        try {
            pair = Pair.create(CommitLogPosition.serializer.deserialize(in), ((InputStream)in).available() > 0 ? in.readLong() : Long.MIN_VALUE);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)in).close();
        return pair;
    }

    public static synchronized void updateTokens(InetAddressAndPort ep, Collection<Token> tokens) {
        if (ep.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return;
        }
        String req = "INSERT INTO system.%s (peer, tokens) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEERS), ep.getAddress(), SystemKeyspace.tokensAsSet(tokens));
        req = "INSERT INTO system.%s (peer, peer_port, tokens) VALUES (?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_V2), ep.getAddress(), ep.getPort(), SystemKeyspace.tokensAsSet(tokens));
    }

    public static synchronized boolean updatePreferredIP(InetAddressAndPort ep, InetAddressAndPort preferred_ip) {
        if (preferred_ip.equals(SystemKeyspace.getPreferredIP(ep))) {
            return false;
        }
        String req = "INSERT INTO system.%s (peer, preferred_ip) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEERS), ep.getAddress(), preferred_ip.getAddress());
        req = "INSERT INTO system.%s (peer, peer_port, preferred_ip, preferred_port) VALUES (?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_V2), ep.getAddress(), ep.getPort(), preferred_ip.getAddress(), preferred_ip.getPort());
        SystemKeyspace.forceBlockingFlush(LEGACY_PEERS, PEERS_V2);
        return true;
    }

    public static synchronized void updatePeerInfo(InetAddressAndPort ep, String columnName, Object value) {
        if (ep.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return;
        }
        String req = "INSERT INTO system.%s (peer, %s) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEERS, columnName), ep.getAddress(), value);
        if (columnName.equals("rpc_address")) {
            columnName = "native_address";
        }
        req = "INSERT INTO system.%s (peer, peer_port, %s) VALUES (?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_V2, columnName), ep.getAddress(), ep.getPort(), value);
    }

    public static synchronized void updatePeerNativeAddress(InetAddressAndPort ep, InetAddressAndPort address) {
        if (ep.equals(FBUtilities.getBroadcastAddressAndPort())) {
            return;
        }
        String req = "INSERT INTO system.%s (peer, rpc_address) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEERS), ep.getAddress(), address.getAddress());
        req = "INSERT INTO system.%s (peer, peer_port, native_address, native_port) VALUES (?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS_V2), ep.getAddress(), ep.getPort(), address.getAddress(), address.getPort());
    }

    public static synchronized void updateHintsDropped(InetAddressAndPort ep, TimeUUID timePeriod, int value) {
        String req = "UPDATE system.%s USING TTL 2592000 SET hints_dropped[ ? ] = ? WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEER_EVENTS), timePeriod, value, ep.getAddress());
        req = "UPDATE system.%s USING TTL 2592000 SET hints_dropped[ ? ] = ? WHERE peer = ? AND peer_port = ?";
        QueryProcessor.executeInternal(String.format(req, PEER_EVENTS_V2), timePeriod, value, ep.getAddress(), ep.getPort());
    }

    public static synchronized void updateSchemaVersion(UUID version) {
        String req = "INSERT INTO system.%s (key, schema_version) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), version);
    }

    private static Set<String> tokensAsSet(Collection<Token> tokens) {
        if (tokens.isEmpty()) {
            return Collections.emptySet();
        }
        Token.TokenFactory factory = StorageService.instance.getTokenFactory();
        HashSet<String> s = new HashSet<String>(tokens.size());
        for (Token tk : tokens) {
            s.add(factory.toString(tk));
        }
        return s;
    }

    private static Collection<Token> deserializeTokens(Collection<String> tokensStrings) {
        Token.TokenFactory factory = StorageService.instance.getTokenFactory();
        ArrayList<Token> tokens = new ArrayList<Token>(tokensStrings.size());
        for (String tk : tokensStrings) {
            tokens.add(factory.fromString(tk));
        }
        return tokens;
    }

    public static synchronized void removeEndpoint(InetSocketAddress ep) {
        String req = "DELETE FROM system.%s WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, LEGACY_PEERS), ep.getAddress());
        req = String.format("DELETE FROM system.%s WHERE peer = ? AND peer_port = ?", PEERS_V2);
        QueryProcessor.executeInternal(req, ep.getAddress(), ep.getPort());
        SystemKeyspace.forceBlockingFlush(LEGACY_PEERS, PEERS_V2);
    }

    public static synchronized void updateTokens(Collection<Token> tokens) {
        assert (!tokens.isEmpty()) : "removeEndpoint should be used instead";
        Collection<Token> savedTokens = SystemKeyspace.getSavedTokens();
        if (tokens.containsAll(savedTokens) && tokens.size() == savedTokens.size()) {
            return;
        }
        String req = "INSERT INTO system.%s (key, tokens) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), SystemKeyspace.tokensAsSet(tokens));
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static void forceBlockingFlush(String ... cfnames) {
        if (!DatabaseDescriptor.isUnsafeSystem()) {
            ArrayList<Future<CommitLogPosition>> futures = new ArrayList<Future<CommitLogPosition>>();
            for (String cfname : cfnames) {
                futures.add(Keyspace.open("system").getColumnFamilyStore(cfname).forceFlush(ColumnFamilyStore.FlushReason.INTERNALLY_FORCED));
            }
            FBUtilities.waitOnFutures(futures);
        }
    }

    public static SetMultimap<InetAddressAndPort, Token> loadTokens() {
        HashMultimap tokenMap = HashMultimap.create();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, peer_port, tokens FROM system.peers_v2", new Object[0])) {
            InetAddress address = row.getInetAddress("peer");
            Integer port = row.getInt("peer_port");
            InetAddressAndPort peer = InetAddressAndPort.getByAddressOverrideDefaults(address, port);
            if (!row.has("tokens")) continue;
            tokenMap.putAll((Object)peer, SystemKeyspace.deserializeTokens(row.getSet("tokens", UTF8Type.instance)));
        }
        return tokenMap;
    }

    public static Map<InetAddressAndPort, UUID> loadHostIds() {
        HashMap<InetAddressAndPort, UUID> hostIdMap = new HashMap<InetAddressAndPort, UUID>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, peer_port, host_id FROM system.peers_v2", new Object[0])) {
            InetAddress address = row.getInetAddress("peer");
            Integer port = row.getInt("peer_port");
            InetAddressAndPort peer = InetAddressAndPort.getByAddressOverrideDefaults(address, port);
            if (!row.has("host_id")) continue;
            hostIdMap.put(peer, row.getUUID("host_id"));
        }
        return hostIdMap;
    }

    public static InetAddressAndPort getPreferredIP(InetAddressAndPort ep) {
        Preconditions.checkState((boolean)DatabaseDescriptor.isDaemonInitialized());
        String req = "SELECT preferred_ip, preferred_port FROM system.%s WHERE peer=? AND peer_port = ?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS_V2), ep.getAddress(), ep.getPort());
        if (!result.isEmpty() && result.one().has("preferred_ip")) {
            UntypedResultSet.Row row = result.one();
            return InetAddressAndPort.getByAddressOverrideDefaults(row.getInetAddress("preferred_ip"), row.getInt("preferred_port"));
        }
        return ep;
    }

    public static Map<InetAddressAndPort, Map<String, String>> loadDcRackInfo() {
        HashMap<InetAddressAndPort, Map<String, String>> result = new HashMap<InetAddressAndPort, Map<String, String>>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, peer_port, data_center, rack from system.peers_v2", new Object[0])) {
            InetAddress address = row.getInetAddress("peer");
            Integer port = row.getInt("peer_port");
            InetAddressAndPort peer = InetAddressAndPort.getByAddressOverrideDefaults(address, port);
            if (!row.has("data_center") || !row.has("rack")) continue;
            HashMap<String, String> dcRack = new HashMap<String, String>();
            dcRack.put("data_center", row.getString("data_center"));
            dcRack.put("rack", row.getString("rack"));
            result.put(peer, dcRack);
        }
        return result;
    }

    public static CassandraVersion getReleaseVersion(InetAddressAndPort ep) {
        try {
            if (FBUtilities.getBroadcastAddressAndPort().equals(ep)) {
                return CURRENT_VERSION;
            }
            String req = "SELECT release_version FROM system.%s WHERE peer=? AND peer_port=?";
            UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS_V2), ep.getAddress(), ep.getPort());
            if (result != null && result.one().has("release_version")) {
                return new CassandraVersion(result.one().getString("release_version"));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void checkHealth() throws ConfigurationException {
        Keyspace keyspace;
        try {
            keyspace = Keyspace.open("system");
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system keyspace!");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(LOCAL);
        String req = "SELECT cluster_name FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("cluster_name")) {
            if (!cfs.getLiveSSTables().isEmpty()) {
                throw new ConfigurationException("Found system keyspace files, but they couldn't be loaded!");
            }
            return;
        }
        String savedClusterName = result.one().getString("cluster_name");
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Collection<Token> getSavedTokens() {
        String req = "SELECT tokens FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        return result.isEmpty() || !result.one().has("tokens") ? Collections.emptyList() : SystemKeyspace.deserializeTokens(result.one().getSet("tokens", UTF8Type.instance));
    }

    public static int incrementAndGetGeneration() {
        int generation;
        String req = "SELECT gossip_generation FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("gossip_generation")) {
            generation = (int)(Clock.Global.currentTimeMillis() / 1000L);
        } else {
            int now;
            int storedGeneration = result.one().getInt("gossip_generation") + 1;
            if (storedGeneration >= (now = (int)(Clock.Global.currentTimeMillis() / 1000L))) {
                logger.warn("Using stored Gossip Generation {} as it is greater than current system time {}.  See CASSANDRA-3654 if you experience problems", (Object)storedGeneration, (Object)now);
                generation = storedGeneration;
            } else {
                generation = now;
            }
        }
        req = "INSERT INTO system.%s (key, gossip_generation) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), generation);
        SystemKeyspace.forceBlockingFlush(LOCAL);
        return generation;
    }

    public static BootstrapState getBootstrapState() {
        String req = "SELECT bootstrapped FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("bootstrapped")) {
            return BootstrapState.NEEDS_BOOTSTRAP;
        }
        return BootstrapState.valueOf(result.one().getString("bootstrapped"));
    }

    public static boolean bootstrapComplete() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.COMPLETED;
    }

    public static boolean bootstrapInProgress() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.IN_PROGRESS;
    }

    public static boolean wasDecommissioned() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.DECOMMISSIONED;
    }

    public static void setBootstrapState(BootstrapState state) {
        if (SystemKeyspace.getBootstrapState() == state) {
            return;
        }
        String req = "INSERT INTO system.%s (key, bootstrapped) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), state.name());
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static boolean isIndexBuilt(String keyspaceName, String indexName) {
        String req = "SELECT index_name FROM %s.\"%s\" WHERE table_name=? AND index_name=?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, "system", BUILT_INDEXES), keyspaceName, indexName);
        return !result.isEmpty();
    }

    public static void setIndexBuilt(String keyspaceName, String indexName) {
        String req = "INSERT INTO %s.\"%s\" (table_name, index_name) VALUES (?, ?) IF NOT EXISTS;";
        QueryProcessor.executeInternal(String.format(req, "system", BUILT_INDEXES), keyspaceName, indexName);
        SystemKeyspace.forceBlockingFlush(BUILT_INDEXES);
    }

    public static void setIndexRemoved(String keyspaceName, String indexName) {
        String req = "DELETE FROM %s.\"%s\" WHERE table_name = ? AND index_name = ? IF EXISTS";
        QueryProcessor.executeInternal(String.format(req, "system", BUILT_INDEXES), keyspaceName, indexName);
        SystemKeyspace.forceBlockingFlush(BUILT_INDEXES);
    }

    public static List<String> getBuiltIndexes(String keyspaceName, Set<String> indexNames) {
        ArrayList<String> names = new ArrayList<String>(indexNames);
        String req = "SELECT index_name from %s.\"%s\" WHERE table_name=? AND index_name IN ?";
        UntypedResultSet results = QueryProcessor.executeInternal(String.format(req, "system", BUILT_INDEXES), keyspaceName, names);
        return StreamSupport.stream(results.spliterator(), false).map(r -> r.getString("index_name")).collect(Collectors.toList());
    }

    public static UUID getLocalHostId() {
        String req = "SELECT host_id FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result != null && !result.isEmpty() && result.one().has("host_id")) {
            return result.one().getUUID("host_id");
        }
        return null;
    }

    public static synchronized UUID getOrInitializeLocalHostId() {
        return SystemKeyspace.getOrInitializeLocalHostId(UUID::randomUUID);
    }

    private static synchronized UUID getOrInitializeLocalHostId(Supplier<UUID> nodeIdSupplier) {
        UUID hostId = SystemKeyspace.getLocalHostId();
        if (hostId != null) {
            return hostId;
        }
        hostId = nodeIdSupplier.get();
        logger.warn("No host ID found, created {} (Note: This should happen exactly once per node).", (Object)hostId);
        return SystemKeyspace.setLocalHostId(hostId);
    }

    public static synchronized UUID setLocalHostId(UUID hostId) {
        String req = "INSERT INTO system.%s (key, host_id) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), hostId);
        SystemKeyspace.forceBlockingFlush(LOCAL);
        return hostId;
    }

    public static UUID getSchemaVersion() {
        String req = "SELECT schema_version FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (!result.isEmpty() && result.one().has("schema_version")) {
            return result.one().getUUID("schema_version");
        }
        return null;
    }

    public static String getRack() {
        String req = "SELECT rack FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (!result.isEmpty() && result.one().has("rack")) {
            return result.one().getString("rack");
        }
        return null;
    }

    public static String getDatacenter() {
        String req = "SELECT data_center FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (!result.isEmpty() && result.one().has("data_center")) {
            return result.one().getString("data_center");
        }
        return null;
    }

    public static PaxosState.Snapshot loadPaxosState(DecoratedKey partitionKey, TableMetadata metadata, long nowInSec) {
        Ballot promised;
        Row row;
        Ballot promisedWrite;
        String cql = "SELECT * FROM system.paxos WHERE row_key = ? AND cf_id = ?";
        List<Row> results = QueryProcessor.executeInternalRawWithNow(nowInSec, cql, partitionKey.getKey(), metadata.id.asUUID()).get(partitionKey);
        if (results == null || results.isEmpty()) {
            Commit.Committed noneCommitted = Commit.Committed.none(partitionKey, metadata);
            return new PaxosState.Snapshot(Ballot.none(), Ballot.none(), null, noneCommitted);
        }
        long purgeBefore = 0L;
        long overrideTtlSeconds = 0L;
        switch (DatabaseDescriptor.paxosStatePurging()) {
            default: {
                throw new AssertionError();
            }
            case legacy: 
            case gc_grace: {
                overrideTtlSeconds = metadata.params.gcGraceSeconds;
                if (nowInSec <= 0L) break;
                purgeBefore = TimeUnit.SECONDS.toMicros(nowInSec - overrideTtlSeconds);
                break;
            }
            case repaired: {
                ColumnFamilyStore cfs = Keyspace.openAndGetStoreIfExists(metadata);
                if (cfs == null) break;
                long paxosPurgeGraceMicros = DatabaseDescriptor.getPaxosPurgeGrace(TimeUnit.MICROSECONDS);
                purgeBefore = cfs.getPaxosRepairLowBound(partitionKey).uuidTimestamp() - paxosPurgeGraceMicros;
            }
        }
        if ((promisedWrite = PaxosRows.getWritePromise(row = results.get(0))).uuidTimestamp() < purgeBefore) {
            promisedWrite = Ballot.none();
        }
        if ((promised = Commit.latest(promisedWrite, PaxosRows.getPromise(row))).uuidTimestamp() < purgeBefore) {
            promised = Ballot.none();
        }
        Commit.Accepted accepted = PaxosRows.getAccepted(row, purgeBefore, overrideTtlSeconds);
        Commit.Committed committed = PaxosRows.getCommitted(metadata, partitionKey, row, purgeBefore, overrideTtlSeconds);
        if (accepted != null && !accepted.isAfter(committed)) {
            accepted = null;
        }
        return new PaxosState.Snapshot(promised, promisedWrite, accepted, committed);
    }

    public static int legacyPaxosTtlSec(TableMetadata metadata) {
        return Math.max(10800, metadata.params.gcGraceSeconds);
    }

    public static void savePaxosWritePromise(DecoratedKey key, TableMetadata metadata, Ballot ballot) {
        if (DatabaseDescriptor.paxosStatePurging() == Config.PaxosStatePurging.legacy) {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? AND TTL ? SET in_progress_ballot = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, ballot.unixMicros(), SystemKeyspace.legacyPaxosTtlSec(metadata), ballot, key.getKey(), metadata.id.asUUID());
        } else {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? SET in_progress_ballot = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, ballot.unixMicros(), ballot, key.getKey(), metadata.id.asUUID());
        }
    }

    public static void savePaxosReadPromise(DecoratedKey key, TableMetadata metadata, Ballot ballot) {
        if (DatabaseDescriptor.paxosStatePurging() == Config.PaxosStatePurging.legacy) {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? AND TTL ? SET in_progress_read_ballot = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, ballot.unixMicros(), SystemKeyspace.legacyPaxosTtlSec(metadata), ballot, key.getKey(), metadata.id.asUUID());
        } else {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? SET in_progress_read_ballot = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, ballot.unixMicros(), ballot, key.getKey(), metadata.id.asUUID());
        }
    }

    public static void savePaxosProposal(Commit proposal) {
        if (proposal instanceof Commit.AcceptedWithTTL) {
            long localDeletionTime = ((Commit.AcceptedWithTTL)proposal).localDeletionTime;
            int ttlInSec = SystemKeyspace.legacyPaxosTtlSec(proposal.update.metadata());
            long nowInSec = localDeletionTime - (long)ttlInSec;
            String cql = "UPDATE system.paxos USING TIMESTAMP ? AND TTL ? SET proposal_ballot = ?, proposal = ?, proposal_version = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternalWithNowInSec(cql, nowInSec, proposal.ballot.unixMicros(), ttlInSec, proposal.ballot, PartitionUpdate.toBytes(proposal.update, MessagingService.current_version), MessagingService.current_version, proposal.update.partitionKey().getKey(), proposal.update.metadata().id.asUUID());
        } else {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? SET proposal_ballot = ?, proposal = ?, proposal_version = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, proposal.ballot.unixMicros(), proposal.ballot, PartitionUpdate.toBytes(proposal.update, MessagingService.current_version), MessagingService.current_version, proposal.update.partitionKey().getKey(), proposal.update.metadata().id.asUUID());
        }
    }

    public static void savePaxosCommit(Commit commit) {
        if (commit instanceof Commit.CommittedWithTTL) {
            long localDeletionTime = ((Commit.CommittedWithTTL)commit).localDeletionTime;
            int ttlInSec = SystemKeyspace.legacyPaxosTtlSec(commit.update.metadata());
            long nowInSec = localDeletionTime - (long)ttlInSec;
            String cql = "UPDATE system.paxos USING TIMESTAMP ? AND TTL ? SET proposal_ballot = null, proposal = null, proposal_version = null, most_recent_commit_at = ?, most_recent_commit = ?, most_recent_commit_version = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternalWithNowInSec(cql, nowInSec, commit.ballot.unixMicros(), ttlInSec, commit.ballot, PartitionUpdate.toBytes(commit.update, MessagingService.current_version), MessagingService.current_version, commit.update.partitionKey().getKey(), commit.update.metadata().id.asUUID());
        } else {
            String cql = "UPDATE system.paxos USING TIMESTAMP ? SET proposal_ballot = null, proposal = null, proposal_version = null, most_recent_commit_at = ?, most_recent_commit = ?, most_recent_commit_version = ? WHERE row_key = ? AND cf_id = ?";
            QueryProcessor.executeInternal(cql, commit.ballot.unixMicros(), commit.ballot, PartitionUpdate.toBytes(commit.update, MessagingService.current_version), MessagingService.current_version, commit.update.partitionKey().getKey(), commit.update.metadata().id.asUUID());
        }
    }

    @VisibleForTesting
    public static void savePaxosRepairHistory(String keyspace, String table, PaxosRepairHistory history, boolean flush) {
        String cql = "INSERT INTO system.%s (keyspace_name, table_name, points) VALUES (?, ?, ?)";
        QueryProcessor.executeInternal(String.format(cql, PAXOS_REPAIR_HISTORY), keyspace, table, history.toTupleBufferList());
        if (flush) {
            SystemKeyspace.flushPaxosRepairHistory();
        }
    }

    public static void flushPaxosRepairHistory() {
        Schema.instance.getColumnFamilyStoreInstance(SystemKeyspace.PaxosRepairHistoryTable.id).forceBlockingFlush(ColumnFamilyStore.FlushReason.INTERNALLY_FORCED);
    }

    public static PaxosRepairHistory loadPaxosRepairHistory(String keyspace, String table) {
        if (SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES.contains(keyspace)) {
            return PaxosRepairHistory.EMPTY;
        }
        UntypedResultSet results = QueryProcessor.executeInternal(String.format("SELECT * FROM system.%s WHERE keyspace_name=? AND table_name=?", PAXOS_REPAIR_HISTORY), keyspace, table);
        if (results.isEmpty()) {
            return PaxosRepairHistory.EMPTY;
        }
        UntypedResultSet.Row row = (UntypedResultSet.Row)Iterables.getOnlyElement((Iterable)results);
        List<ByteBuffer> points = row.getList("points", BytesType.instance);
        return PaxosRepairHistory.fromTupleBufferList(points);
    }

    public static RestorableMeter getSSTableReadMeter(String keyspace, String table, SSTableId id) {
        UntypedResultSet results = SystemKeyspace.readSSTableActivity(keyspace, table, id);
        if (results.isEmpty()) {
            return new RestorableMeter();
        }
        UntypedResultSet.Row row = results.one();
        double m15rate = row.getDouble("rate_15m");
        double m120rate = row.getDouble("rate_120m");
        return new RestorableMeter(m15rate, m120rate);
    }

    @VisibleForTesting
    public static UntypedResultSet readSSTableActivity(String keyspace, String table, SSTableId id) {
        String cql = "SELECT * FROM system.%s WHERE keyspace_name=? and table_name=? and id=?";
        return QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_V2), keyspace, table, id.toString());
    }

    public static void persistSSTableReadMeter(String keyspace, String table, SSTableId id, RestorableMeter meter) {
        String cql = "INSERT INTO system.%s (keyspace_name, table_name, id, rate_15m, rate_120m) VALUES (?, ?, ?, ?, ?) USING TTL 864000";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_V2), keyspace, table, id.toString(), meter.fifteenMinuteRate(), meter.twoHourRate());
        if (!DatabaseDescriptor.isUUIDSSTableIdentifiersEnabled() && id instanceof SequenceBasedSSTableId) {
            cql = "INSERT INTO system.%s (keyspace_name, columnfamily_name, generation, rate_15m, rate_120m) VALUES (?, ?, ?, ?, ?) USING TTL 864000";
            QueryProcessor.executeInternal(String.format(cql, LEGACY_SSTABLE_ACTIVITY), keyspace, table, ((SequenceBasedSSTableId)id).generation, meter.fifteenMinuteRate(), meter.twoHourRate());
        }
    }

    public static void clearSSTableReadMeter(String keyspace, String table, SSTableId id) {
        String cql = "DELETE FROM system.%s WHERE keyspace_name=? AND table_name=? and id=?";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY_V2), keyspace, table, id.toString());
        if (!DatabaseDescriptor.isUUIDSSTableIdentifiersEnabled() && id instanceof SequenceBasedSSTableId) {
            cql = "DELETE FROM system.%s WHERE keyspace_name=? AND columnfamily_name=? and generation=?";
            QueryProcessor.executeInternal(String.format(cql, LEGACY_SSTABLE_ACTIVITY), keyspace, table, ((SequenceBasedSSTableId)id).generation);
        }
    }

    public static void updateSizeEstimates(String keyspace, String table, Map<Range<Token>, Pair<Long, Long>> estimates) {
        long timestamp = FBUtilities.timestampMicros();
        long nowInSec = FBUtilities.nowInSeconds();
        PartitionUpdate.Builder update = new PartitionUpdate.Builder(LegacySizeEstimates, UTF8Type.instance.decompose(keyspace), LegacySizeEstimates.regularAndStaticColumns(), estimates.size());
        update.add(new RangeTombstone(Slice.make(SystemKeyspace.LegacySizeEstimates.comparator, table), DeletionTime.build(timestamp - 1L, nowInSec)));
        for (Map.Entry<Range<Token>, Pair<Long, Long>> entry : estimates.entrySet()) {
            Range<Token> range = entry.getKey();
            Pair<Long, Long> values = entry.getValue();
            update.add(Rows.simpleBuilder(LegacySizeEstimates, table, ((Token)range.left).toString(), ((Token)range.right).toString()).timestamp(timestamp).add("partitions_count", values.left).add("mean_partition_size", values.right).build());
        }
        new Mutation(update.build()).apply();
    }

    public static void updateTableEstimates(String keyspace, String table, String type, Map<Range<Token>, Pair<Long, Long>> estimates) {
        long timestamp = FBUtilities.timestampMicros();
        long nowInSec = FBUtilities.nowInSeconds();
        PartitionUpdate.Builder update = new PartitionUpdate.Builder(TableEstimates, UTF8Type.instance.decompose(keyspace), TableEstimates.regularAndStaticColumns(), estimates.size());
        update.add(new RangeTombstone(Slice.make(SystemKeyspace.TableEstimates.comparator, table, type), DeletionTime.build(timestamp - 1L, nowInSec)));
        for (Map.Entry<Range<Token>, Pair<Long, Long>> entry : estimates.entrySet()) {
            Range<Token> range = entry.getKey();
            Pair<Long, Long> values = entry.getValue();
            update.add(Rows.simpleBuilder(TableEstimates, table, type, ((Token)range.left).toString(), ((Token)range.right).toString()).timestamp(timestamp).add("partitions_count", values.left).add("mean_partition_size", values.right).build());
        }
        new Mutation(update.build()).apply();
    }

    public static void clearEstimates(String keyspace, String table) {
        String cqlFormat = "DELETE FROM %s WHERE keyspace_name = ? AND table_name = ?";
        String cql = String.format(cqlFormat, LegacySizeEstimates.toString());
        QueryProcessor.executeInternal(cql, keyspace, table);
        cql = String.format(cqlFormat, TableEstimates.toString());
        QueryProcessor.executeInternal(cql, keyspace, table);
    }

    public static void clearAllEstimates() {
        for (String table : Arrays.asList(LEGACY_SIZE_ESTIMATES, TABLE_ESTIMATES)) {
            ColumnFamilyStore cfs = Keyspace.open("system").getColumnFamilyStore(table);
            cfs.truncateBlockingWithoutSnapshot();
        }
    }

    public static synchronized void updateAvailableRanges(String keyspace, Collection<Range<Token>> completedFullRanges, Collection<Range<Token>> completedTransientRanges) {
        String cql = "UPDATE system.%s SET full_ranges = full_ranges + ?, transient_ranges = transient_ranges + ? WHERE keyspace_name = ?";
        QueryProcessor.executeInternal(String.format(cql, AVAILABLE_RANGES_V2), completedFullRanges.stream().map(SystemKeyspace::rangeToBytes).collect(Collectors.toSet()), completedTransientRanges.stream().map(SystemKeyspace::rangeToBytes).collect(Collectors.toSet()), keyspace);
    }

    public static synchronized AvailableRanges getAvailableRanges(String keyspace, IPartitioner partitioner) {
        String query = "SELECT * FROM system.%s WHERE keyspace_name=?";
        UntypedResultSet rs = QueryProcessor.executeInternal(String.format(query, AVAILABLE_RANGES_V2), keyspace);
        ImmutableSet.Builder full = new ImmutableSet.Builder();
        ImmutableSet.Builder trans = new ImmutableSet.Builder();
        for (UntypedResultSet.Row row : rs) {
            Optional.ofNullable(row.getSet("full_ranges", BytesType.instance)).ifPresent(full_ranges -> full_ranges.stream().map(buf -> SystemKeyspace.byteBufferToRange(buf, partitioner)).forEach(arg_0 -> ((ImmutableSet.Builder)full).add(arg_0)));
            Optional.ofNullable(row.getSet("transient_ranges", BytesType.instance)).ifPresent(transient_ranges -> transient_ranges.stream().map(buf -> SystemKeyspace.byteBufferToRange(buf, partitioner)).forEach(arg_0 -> ((ImmutableSet.Builder)trans).add(arg_0)));
        }
        return new AvailableRanges((Set<Range<Token>>)full.build(), (Set<Range<Token>>)trans.build());
    }

    public static void resetAvailableStreamedRanges() {
        ColumnFamilyStore availableRanges = Keyspace.open("system").getColumnFamilyStore(AVAILABLE_RANGES_V2);
        availableRanges.truncateBlockingWithoutSnapshot();
    }

    public static void resetAvailableStreamedRangesForKeyspace(String keyspace) {
        String cql = "DELETE FROM %s.%s WHERE keyspace_name = ?";
        QueryProcessor.executeInternal(String.format(cql, "system", AVAILABLE_RANGES_V2), keyspace);
    }

    public static synchronized void updateTransferredRanges(StreamOperation streamOperation, InetAddressAndPort peer, String keyspace, Collection<Range<Token>> streamedRanges) {
        String cql = "UPDATE system.%s SET ranges = ranges + ? WHERE operation = ? AND peer = ? AND keyspace_name = ?";
        HashSet<ByteBuffer> rangesToUpdate = new HashSet<ByteBuffer>(streamedRanges.size());
        for (Range<Token> range : streamedRanges) {
            rangesToUpdate.add(SystemKeyspace.rangeToBytes(range));
        }
        QueryProcessor.executeInternal(String.format(cql, LEGACY_TRANSFERRED_RANGES), rangesToUpdate, streamOperation.getDescription(), peer.getAddress(), keyspace);
        cql = "UPDATE system.%s SET ranges = ranges + ? WHERE operation = ? AND peer = ? AND peer_port = ? AND keyspace_name = ?";
        QueryProcessor.executeInternal(String.format(cql, TRANSFERRED_RANGES_V2), rangesToUpdate, streamOperation.getDescription(), peer.getAddress(), peer.getPort(), keyspace);
    }

    public static synchronized Map<InetAddressAndPort, Set<Range<Token>>> getTransferredRanges(String description, String keyspace, IPartitioner partitioner) {
        HashMap<InetAddressAndPort, HashSet> result = new HashMap<InetAddressAndPort, HashSet>();
        String query = "SELECT * FROM system.%s WHERE operation = ? AND keyspace_name = ?";
        UntypedResultSet rs = QueryProcessor.executeInternal(String.format(query, TRANSFERRED_RANGES_V2), description, keyspace);
        for (UntypedResultSet.Row row : rs) {
            InetAddress peerAddress = row.getInetAddress("peer");
            int port = row.getInt("peer_port");
            InetAddressAndPort peer = InetAddressAndPort.getByAddressOverrideDefaults(peerAddress, port);
            Set<ByteBuffer> rawRanges = row.getSet("ranges", BytesType.instance);
            HashSet ranges = Sets.newHashSetWithExpectedSize((int)rawRanges.size());
            for (ByteBuffer rawRange : rawRanges) {
                ranges.add(SystemKeyspace.byteBufferToRange(rawRange, partitioner));
            }
            result.put(peer, ranges);
        }
        return ImmutableMap.copyOf(result);
    }

    public static void snapshotOnVersionChange() throws IOException {
        String previous = SystemKeyspace.getPreviousVersionString();
        String next = FBUtilities.getReleaseVersionString();
        FBUtilities.setPreviousReleaseVersionString(previous);
        if (!previous.equals(CassandraVersion.NULL_VERSION.toString()) && !previous.equals(next)) {
            logger.info("Detected version upgrade from {} to {}, snapshotting system keyspaces", (Object)previous, (Object)next);
            String snapshotName = Keyspace.getTimestampedSnapshotName(String.format("upgrade-%s-%s", previous, next));
            Instant creationTime = FBUtilities.now();
            for (String keyspace : SchemaConstants.LOCAL_SYSTEM_KEYSPACE_NAMES) {
                Keyspace.open(keyspace).snapshot(snapshotName, null, false, null, null, creationTime);
            }
        }
    }

    private static String getPreviousVersionString() {
        String req = "SELECT release_version FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("release_version")) {
            for (File dataDirectory : Directories.getKSChildDirectories("system")) {
                if (!dataDirectory.name().equals("Versions") || dataDirectory.tryList().length <= 0) continue;
                logger.trace("Found unreadable versions info in pre 1.2 system.Versions table");
                return CassandraVersion.UNREADABLE_VERSION.toString();
            }
            return CassandraVersion.NULL_VERSION.toString();
        }
        return result.one().getString("release_version");
    }

    @VisibleForTesting
    public static Set<Range<Token>> rawRangesToRangeSet(Set<ByteBuffer> rawRanges, IPartitioner partitioner) {
        return rawRanges.stream().map(buf -> SystemKeyspace.byteBufferToRange(buf, partitioner)).collect(Collectors.toSet());
    }

    @VisibleForTesting
    public static ByteBuffer rangeToBytes(Range<Token> range) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            Range.tokenSerializer.serialize(range, out, 0);
            ByteBuffer byteBuffer = out.buffer();
            out.close();
            return byteBuffer;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    private static Range<Token> byteBufferToRange(ByteBuffer rawRange, IPartitioner partitioner) {
        try {
            return (Range)Range.tokenSerializer.deserialize((DataInput)ByteStreams.newDataInput((byte[])ByteBufferUtil.getArray(rawRange)), partitioner, 0);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void writePreparedStatement(String loggedKeyspace, MD5Digest key, String cql, long timestamp) {
        QueryProcessor.executeInternal(String.format("INSERT INTO %s (logged_keyspace, prepared_id, query_string) VALUES (?, ?, ?) USING TIMESTAMP ?", PreparedStatements.toString()), loggedKeyspace, key.byteBuffer(), cql, timestamp);
        logger.debug("stored prepared statement for logged keyspace '{}': '{}'", (Object)loggedKeyspace, (Object)cql);
    }

    public static void removePreparedStatement(MD5Digest key) {
        QueryProcessor.executeInternal(String.format("DELETE FROM %s WHERE prepared_id = ?", PreparedStatements.toString()), key.byteBuffer());
    }

    public static void resetPreparedStatements() {
        ColumnFamilyStore preparedStatements = Keyspace.open("system").getColumnFamilyStore(PREPARED_STATEMENTS);
        preparedStatements.truncateBlockingWithoutSnapshot();
    }

    public static int loadPreparedStatements(TriFunction<MD5Digest, String, String, QueryHandler.Prepared> onLoaded) {
        return SystemKeyspace.loadPreparedStatements(onLoaded, 5000);
    }

    public static int loadPreparedStatements(TriFunction<MD5Digest, String, String, QueryHandler.Prepared> onLoaded, int pageSize) {
        String query = String.format("SELECT prepared_id, logged_keyspace, query_string FROM %s.%s", "system", PREPARED_STATEMENTS);
        UntypedResultSet resultSet = QueryProcessor.executeOnceInternalWithPaging(query, pageSize, new Object[0]);
        int counter = 0;
        long preparedBytesLoadThreshold = (long)((double)QueryProcessor.PREPARED_STATEMENT_CACHE_SIZE_BYTES * 1.1);
        long preparedBytesLoaded = 0L;
        for (UntypedResultSet.Row row : resultSet) {
            QueryHandler.Prepared prepared = onLoaded.accept(MD5Digest.wrap(row.getByteArray("prepared_id")), row.getString("query_string"), row.has("logged_keyspace") ? row.getString("logged_keyspace") : null);
            if (prepared == null) continue;
            ++counter;
            if ((preparedBytesLoaded += (long)Math.max(0, prepared.pstmntSize)) <= preparedBytesLoadThreshold) continue;
            logger.warn("Detected prepared statement cache filling up during preload after preparing {} statements (loaded {} with prepared_statements_cache_size being {}). This could be an indication that prepared statements leaked prior to CASSANDRA-19703 being fixed. Returning early to prevent indefinite startup. Consider truncating {}.{} to clear out leaked prepared statements.", new Object[]{counter, FileUtils.stringifyFileSize(preparedBytesLoaded), FileUtils.stringifyFileSize(QueryProcessor.PREPARED_STATEMENT_CACHE_SIZE_BYTES), "system", PREPARED_STATEMENTS});
            break;
        }
        return counter;
    }

    public static int loadPreparedStatement(MD5Digest digest, TriFunction<MD5Digest, String, String, Boolean> onLoaded) {
        String query = String.format("SELECT prepared_id, logged_keyspace, query_string FROM %s.%s WHERE prepared_id = ?", "system", PREPARED_STATEMENTS);
        UntypedResultSet resultSet = QueryProcessor.executeOnceInternal(query, digest.byteBuffer());
        int counter = 0;
        for (UntypedResultSet.Row row : resultSet) {
            if (!onLoaded.accept(MD5Digest.wrap(row.getByteArray("prepared_id")), row.getString("query_string"), row.has("logged_keyspace") ? row.getString("logged_keyspace") : null).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static void saveTopPartitions(TableMetadata metadata, String topType, Collection<TopPartitionTracker.TopPartition> topPartitions, long lastUpdate) {
        String cql = String.format("INSERT INTO %s.%s (keyspace_name, table_name, top_type, top, last_update) values (?, ?, ?, ?, ?)", "system", TOP_PARTITIONS);
        ArrayList tupleList = new ArrayList(topPartitions.size());
        topPartitions.forEach(tp -> {
            String key = metadata.partitionKeyType.getString(tp.key.getKey());
            tupleList.add(TupleType.buildValue(UTF8Type.instance.decompose(key), LongType.instance.decompose(tp.value)));
        });
        QueryProcessor.executeInternal(cql, metadata.keyspace, metadata.name, topType, tupleList, Date.from(Instant.ofEpochMilli(lastUpdate)));
    }

    public static TopPartitionTracker.StoredTopPartitions getTopPartitions(TableMetadata metadata, String topType) {
        try {
            String cql = String.format("SELECT top, last_update FROM %s.%s WHERE keyspace_name = ? and table_name = ? and top_type = ?", "system", TOP_PARTITIONS);
            UntypedResultSet res = QueryProcessor.executeInternal(cql, metadata.keyspace, metadata.name, topType);
            if (res == null || res.isEmpty()) {
                return TopPartitionTracker.StoredTopPartitions.EMPTY;
            }
            UntypedResultSet.Row row = res.one();
            long lastUpdated = row.getLong("last_update");
            List<ByteBuffer> top = row.getList("top", BytesType.instance);
            if (top == null || top.isEmpty()) {
                return TopPartitionTracker.StoredTopPartitions.EMPTY;
            }
            ArrayList<TopPartitionTracker.TopPartition> topPartitions = new ArrayList<TopPartitionTracker.TopPartition>(top.size());
            TupleType tupleType = new TupleType(Lists.newArrayList((Object[])new AbstractType[]{UTF8Type.instance, LongType.instance}));
            for (ByteBuffer bb : top) {
                ByteBuffer[] components = tupleType.split(ByteBufferAccessor.instance, bb);
                String keyStr = (String)UTF8Type.instance.compose(components[0]);
                long value = (Long)LongType.instance.compose(components[1]);
                topPartitions.add(new TopPartitionTracker.TopPartition(metadata.partitioner.decorateKey(metadata.partitionKeyType.fromString(keyStr)), value));
            }
            return new TopPartitionTracker.StoredTopPartitions(topPartitions, lastUpdated);
        }
        catch (Exception e) {
            logger.warn("Could not load stored top {} partitions for {}.{}", new Object[]{topType, metadata.keyspace, metadata.name, e});
            return TopPartitionTracker.StoredTopPartitions.EMPTY;
        }
    }

    public static interface TriFunction<A, B, C, D> {
        public D accept(A var1, B var2, C var3);
    }

    public static class AvailableRanges {
        public Set<Range<Token>> full;
        public Set<Range<Token>> trans;

        private AvailableRanges(Set<Range<Token>> full, Set<Range<Token>> trans) {
            this.full = full;
            this.trans = trans;
        }
    }

    public static enum BootstrapState {
        NEEDS_BOOTSTRAP,
        COMPLETED,
        IN_PROGRESS,
        DECOMMISSIONED;

    }
}

