/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Digest;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.RepairedDataInfo;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.DeserializationHelper;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class ReadResponse {
    public static final IVersionedSerializer<ReadResponse> serializer = new Serializer();

    protected ReadResponse() {
    }

    public static ReadResponse createDataResponse(UnfilteredPartitionIterator data, ReadCommand command, RepairedDataInfo rdi) {
        return new LocalDataResponse(data, command, rdi);
    }

    public static ReadResponse createSimpleDataResponse(UnfilteredPartitionIterator data, ColumnFilter selection) {
        return new LocalDataResponse(data, selection);
    }

    @VisibleForTesting
    public static ReadResponse createRemoteDataResponse(UnfilteredPartitionIterator data, ByteBuffer repairedDataDigest, boolean isRepairedDigestConclusive, ReadCommand command, int version) {
        return new RemoteDataResponse(LocalDataResponse.build(data, command.columnFilter()), repairedDataDigest, isRepairedDigestConclusive, version);
    }

    public static ReadResponse createDigestResponse(UnfilteredPartitionIterator data, ReadCommand command) {
        return new DigestResponse(ReadResponse.makeDigest(data, command));
    }

    public abstract UnfilteredPartitionIterator makeIterator(ReadCommand var1);

    public abstract ByteBuffer digest(ReadCommand var1);

    public abstract ByteBuffer repairedDataDigest();

    public abstract boolean isRepairedDigestConclusive();

    public abstract boolean mayIncludeRepairedDigest();

    public abstract boolean isDigestResponse();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toDebugString(ReadCommand command, DecoratedKey key) {
        if (this.isDigestResponse()) {
            return "Digest:0x" + ByteBufferUtil.bytesToHex(this.digest(command));
        }
        try (UnfilteredPartitionIterator iter = this.makeIterator(command);){
            while (iter.hasNext()) {
                UnfilteredRowIterator partition = (UnfilteredRowIterator)iter.next();
                try {
                    if (!partition.partitionKey().equals(key)) continue;
                    String string = this.toDebugString(partition, command.metadata());
                    return string;
                }
                finally {
                    if (partition == null) continue;
                    partition.close();
                }
            }
            return String.format("<key %s not found (repaired_digest=%s repaired_digest_conclusive=%s)>", key, ByteBufferUtil.bytesToHex(this.repairedDataDigest()), this.isRepairedDigestConclusive());
        }
    }

    private String toDebugString(UnfilteredRowIterator partition, TableMetadata metadata) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s] key=%s partition_deletion=%s columns=%s repaired_digest=%s repaired_digest_conclusive==%s", metadata, metadata.partitionKeyType.getString(partition.partitionKey().getKey()), partition.partitionLevelDeletion(), partition.columns(), ByteBufferUtil.bytesToHex(this.repairedDataDigest()), this.isRepairedDigestConclusive()));
        if (partition.staticRow() != Rows.EMPTY_STATIC_ROW) {
            sb.append("\n    ").append(partition.staticRow().toString(metadata, true));
        }
        while (partition.hasNext()) {
            sb.append("\n    ").append(((Unfiltered)partition.next()).toString(metadata, true));
        }
        return sb.toString();
    }

    protected static ByteBuffer makeDigest(UnfilteredPartitionIterator iterator, ReadCommand command) {
        Digest digest = Digest.forReadResponse();
        UnfilteredPartitionIterators.digest(iterator, digest, command.digestVersion());
        return ByteBuffer.wrap(digest.digest());
    }

    private static class Serializer
    implements IVersionedSerializer<ReadResponse> {
        private Serializer() {
        }

        @Override
        public void serialize(ReadResponse response, DataOutputPlus out, int version) throws IOException {
            assert (version >= 12);
            boolean isDigest = response instanceof DigestResponse;
            ByteBuffer digest = isDigest ? ((DigestResponse)response).digest : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            ByteBufferUtil.writeWithVIntLength(digest, out);
            if (!isDigest) {
                ByteBufferUtil.writeWithVIntLength(response.repairedDataDigest(), out);
                out.writeBoolean(response.isRepairedDigestConclusive());
                ByteBuffer data = ((DataResponse)response).data;
                ByteBufferUtil.writeWithVIntLength(data, out);
            }
        }

        @Override
        public ReadResponse deserialize(DataInputPlus in, int version) throws IOException {
            assert (version >= 12);
            ByteBuffer digest = ByteBufferUtil.readWithVIntLength(in);
            if (digest.hasRemaining()) {
                return new DigestResponse(digest);
            }
            digest = ByteBufferUtil.readWithVIntLength(in);
            boolean repairedDigestConclusive = in.readBoolean();
            ByteBuffer data = ByteBufferUtil.readWithVIntLength(in);
            return new RemoteDataResponse(data, digest, repairedDigestConclusive, version);
        }

        @Override
        public long serializedSize(ReadResponse response, int version) {
            assert (version >= 12);
            boolean isDigest = response instanceof DigestResponse;
            ByteBuffer digest = isDigest ? ((DigestResponse)response).digest : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            long size = ByteBufferUtil.serializedSizeWithVIntLength(digest);
            if (!isDigest) {
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(response.repairedDataDigest());
                ++size;
                ByteBuffer data = ((DataResponse)response).data;
                size += (long)ByteBufferUtil.serializedSizeWithVIntLength(data);
            }
            return size;
        }
    }

    static abstract class DataResponse
    extends ReadResponse {
        private final ByteBuffer data;
        private final ByteBuffer repairedDataDigest;
        private final boolean isRepairedDigestConclusive;
        private final int dataSerializationVersion;
        private final DeserializationHelper.Flag flag;

        protected DataResponse(ByteBuffer data, ByteBuffer repairedDataDigest, boolean isRepairedDigestConclusive, int dataSerializationVersion, DeserializationHelper.Flag flag) {
            this.data = data;
            this.repairedDataDigest = repairedDataDigest;
            this.isRepairedDigestConclusive = isRepairedDigestConclusive;
            this.dataSerializationVersion = dataSerializationVersion;
            this.flag = flag;
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(ReadCommand command) {
            DataInputBuffer in = new DataInputBuffer(this.data, true);
            try {
                UnfilteredPartitionIterator unfilteredPartitionIterator = UnfilteredPartitionIterators.serializerForIntraNode().deserialize(in, this.dataSerializationVersion, command.metadata(), command.columnFilter(), this.flag);
                in.close();
                return unfilteredPartitionIterator;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public boolean mayIncludeRepairedDigest() {
            return this.dataSerializationVersion >= 12;
        }

        @Override
        public ByteBuffer repairedDataDigest() {
            return this.repairedDataDigest;
        }

        @Override
        public boolean isRepairedDigestConclusive() {
            return this.isRepairedDigestConclusive;
        }

        @Override
        public ByteBuffer digest(ReadCommand command) {
            try (UnfilteredPartitionIterator iterator = this.makeIterator(command);){
                ByteBuffer byteBuffer = DataResponse.makeDigest(iterator, command);
                return byteBuffer;
            }
        }

        @Override
        public boolean isDigestResponse() {
            return false;
        }
    }

    private static class RemoteDataResponse
    extends DataResponse {
        protected RemoteDataResponse(ByteBuffer data, ByteBuffer repairedDataDigest, boolean isRepairedDigestConclusive, int version) {
            super(data, repairedDataDigest, isRepairedDigestConclusive, version, DeserializationHelper.Flag.FROM_REMOTE);
        }
    }

    private static class LocalDataResponse
    extends DataResponse {
        private LocalDataResponse(UnfilteredPartitionIterator iter, ReadCommand command, RepairedDataInfo rdi) {
            super(LocalDataResponse.build(iter, command.columnFilter()), rdi.getDigest(), rdi.isConclusive(), MessagingService.current_version, DeserializationHelper.Flag.LOCAL);
        }

        private LocalDataResponse(UnfilteredPartitionIterator iter, ColumnFilter selection) {
            super(LocalDataResponse.build(iter, selection), null, false, MessagingService.current_version, DeserializationHelper.Flag.LOCAL);
        }

        private static ByteBuffer build(UnfilteredPartitionIterator iter, ColumnFilter selection) {
            DataOutputBuffer buffer = new DataOutputBuffer();
            try {
                UnfilteredPartitionIterators.serializerForIntraNode().serialize(iter, selection, buffer, MessagingService.current_version);
                ByteBuffer byteBuffer = buffer.buffer();
                buffer.close();
                return byteBuffer;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static class DigestResponse
    extends ReadResponse {
        private final ByteBuffer digest;

        private DigestResponse(ByteBuffer digest) {
            assert (digest.hasRemaining());
            this.digest = digest;
        }

        @Override
        public UnfilteredPartitionIterator makeIterator(ReadCommand command) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mayIncludeRepairedDigest() {
            return false;
        }

        @Override
        public ByteBuffer repairedDataDigest() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRepairedDigestConclusive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer digest(ReadCommand command) {
            return this.digest;
        }

        @Override
        public boolean isDigestResponse() {
            return true;
        }
    }
}

