/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.Shared;

@Shared(scope={Shared.Scope.SIMULATION})
public class ParameterizedClass {
    public static final String CLASS_NAME = "class_name";
    public static final String PARAMETERS = "parameters";
    public String class_name;
    public Map<String, String> parameters;

    public ParameterizedClass() {
    }

    public ParameterizedClass(String class_name) {
        this(class_name, Collections.emptyMap());
    }

    public ParameterizedClass(String class_name, Map<String, String> parameters) {
        this.class_name = class_name;
        this.parameters = parameters;
    }

    public ParameterizedClass(Map<String, ?> p) {
        this((String)p.get(CLASS_NAME), p.containsKey(PARAMETERS) ? (Map)((List)p.get(PARAMETERS)).get(0) : null);
    }

    /*
     * WARNING - void declaration
     */
    public static <K> K newInstance(ParameterizedClass parameterizedClass, List<String> searchPackages) {
        Class<?> providerClass = null;
        if (searchPackages == null || searchPackages.isEmpty()) {
            searchPackages = Collections.singletonList("");
        }
        for (String string : searchPackages) {
            try {
                void var4_6;
                if (!string.isEmpty() && !string.endsWith(".")) {
                    String string2 = string + ".";
                }
                String name = (String)var4_6 + parameterizedClass.class_name;
                providerClass = Class.forName(name);
            }
            catch (ClassNotFoundException name) {}
        }
        if (providerClass == null) {
            String pkgList = "[" + searchPackages.stream().map(p -> "\"" + p + "\"").collect(Collectors.joining(",")) + "]";
            String string = "Unable to find class " + parameterizedClass.class_name + " in packages " + pkgList;
            throw new ConfigurationException(string);
        }
        try {
            Constructor<?> mapConstructor = ParameterizedClass.filterConstructor(providerClass, c -> c.getParameterTypes().length == 1 && c.getParameterTypes()[0].equals(Map.class));
            if (mapConstructor != null) {
                return (K)mapConstructor.newInstance(parameterizedClass.parameters == null ? Collections.emptyMap() : parameterizedClass.parameters);
            }
            Constructor<?> constructor = ParameterizedClass.filterConstructor(providerClass, c -> c.getParameterTypes().length == 0);
            if (constructor != null) {
                return (K)constructor.newInstance(new Object[0]);
            }
            throw new ConfigurationException("No valid constructor found for class " + parameterizedClass.class_name);
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Unable to instantiate parameterized class " + parameterizedClass.class_name, e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            String error = "Failed to instantiate class " + parameterizedClass.class_name + (String)(throwable.getMessage() != null ? ": " + throwable.getMessage() : "");
            throw new ConfigurationException(error, throwable);
        }
    }

    private static Constructor<?> filterConstructor(Class<?> providerClass, Predicate<Constructor<?>> filter) {
        for (Constructor<?> constructor : providerClass.getDeclaredConstructors()) {
            if (!filter.test(constructor)) continue;
            return constructor;
        }
        return null;
    }

    public boolean equals(Object that) {
        return that instanceof ParameterizedClass && this.equals((ParameterizedClass)that);
    }

    public boolean equals(ParameterizedClass that) {
        return Objects.equal((Object)this.class_name, (Object)that.class_name) && Objects.equal(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.class_name, this.parameters});
    }

    public String toString() {
        return this.class_name + this.parameters;
    }
}

