/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.auth.CIDRGroupsMappingIntervalTree;
import org.apache.cassandra.cql3.CIDR;

public interface CIDRGroupsMappingTable<V> {
    default public String getIPTypeString(boolean isIPv6) {
        return isIPv6 ? "IPv6" : "IPv4";
    }

    public static <V> Builder<V> builder(boolean isIPv6) {
        return new Builder(isIPv6);
    }

    public Set<V> lookupLongestMatchForIP(InetAddress var1);

    public static class Builder<V> {
        private final Map<CIDR, Set<V>> cidrMappings = new HashMap<CIDR, Set<V>>();
        private final boolean isIPv6;

        private Builder(boolean isIPv6) {
            this.isIPv6 = isIPv6;
        }

        public void add(CIDR cidr, V cidrGroup) {
            this.cidrMappings.computeIfAbsent(cidr, k -> new HashSet()).add(cidrGroup);
        }

        public CIDRGroupsMappingTable<V> build() {
            return new CIDRGroupsMappingIntervalTree<V>(this.isIPv6, this.cidrMappings);
        }
    }
}

