/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.stress.generate.values.Dates;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;
import org.apache.cassandra.utils.TimeUUID;

public class TimeUUIDs
extends Generator<UUID> {
    final Dates dateGen;
    final long clockSeqAndNode;

    public TimeUUIDs(String name, GeneratorConfig config) {
        super((AbstractType<?>)TimeUUIDType.instance, config, name, UUID.class);
        this.dateGen = new Dates(name, config);
        this.clockSeqAndNode = config.salt;
    }

    @Override
    public void setSeed(long seed) {
        this.dateGen.setSeed(seed);
    }

    @Override
    public UUID generate() {
        return TimeUUID.atUnixMicrosWithLsb((long)(this.dateGen.generate().getTime() * 1000L), (long)this.clockSeqAndNode).asUUID();
    }
}

