/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class Inets
extends Generator<InetAddress> {
    final byte[] buf = new byte[4];

    public Inets(String name, GeneratorConfig config) {
        super((AbstractType<?>)InetAddressType.instance, config, name, InetAddress.class);
    }

    @Override
    public InetAddress generate() {
        int val = (int)this.identityDistribution.next();
        this.buf[0] = (byte)(val >>> 24);
        this.buf[1] = (byte)(val >>> 16);
        this.buf[2] = (byte)(val >>> 8);
        this.buf[3] = (byte)val;
        try {
            return InetAddress.getByAddress(this.buf);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

