/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableSimpleIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.AbstractIterator;

public class SSTableIdentityIterator
extends AbstractIterator<Unfiltered>
implements Comparable<SSTableIdentityIterator>,
UnfilteredRowIterator {
    private final SSTableReader sstable;
    private final DecoratedKey key;
    private final DeletionTime partitionLevelDeletion;
    private final String filename;
    protected final SSTableSimpleIterator iterator;
    private final Row staticRow;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key) {
        this.sstable = sstable;
        this.filename = file.getPath();
        this.key = key;
        try {
            this.partitionLevelDeletion = DeletionTime.serializer.deserialize(file);
            SerializationHelper helper = new SerializationHelper(sstable.metadata, sstable.descriptor.version.correspondingMessagingVersion(), SerializationHelper.Flag.LOCAL);
            this.iterator = SSTableSimpleIterator.create(sstable.metadata, file, sstable.header, helper, this.partitionLevelDeletion);
            this.staticRow = this.iterator.readStaticRow();
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.filename);
        }
    }

    @Override
    public CFMetaData metadata() {
        return this.sstable.metadata;
    }

    @Override
    public PartitionColumns columns() {
        return this.metadata().partitionColumns();
    }

    @Override
    public boolean isReverseOrder() {
        return false;
    }

    @Override
    public DecoratedKey partitionKey() {
        return this.key;
    }

    @Override
    public DeletionTime partitionLevelDeletion() {
        return this.partitionLevelDeletion;
    }

    @Override
    public Row staticRow() {
        return this.staticRow;
    }

    @Override
    protected Unfiltered computeNext() {
        try {
            return this.doCompute();
        }
        catch (IndexOutOfBoundsException e) {
            this.sstable.markSuspect();
            throw new CorruptSSTableException((Throwable)e, this.filename);
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                this.sstable.markSuspect();
                throw new CorruptSSTableException((Throwable)((Exception)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    protected Unfiltered doCompute() {
        return this.iterator.hasNext() ? (Unfiltered)this.iterator.next() : (Unfiltered)this.endOfData();
    }

    @Override
    public void close() {
    }

    public String getPath() {
        return this.filename;
    }

    @Override
    public EncodingStats stats() {
        return new EncodingStats(this.sstable.getMinTimestamp(), this.sstable.getMinLocalDeletionTime(), this.sstable.getMinTTL());
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }
}

