/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.thrift.util.mem;

import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

class Memory {
    private static final Unsafe unsafe;
    protected long peer;
    protected long size;

    protected Memory(long size) {
        this(unsafe.allocateMemory(size), size);
    }

    protected Memory(long peer, long size) {
        this.peer = peer;
        this.size = size;
    }

    public static Memory allocate(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException();
        }
        return new Memory(bytes);
    }

    public static Memory wrap(long peer, int limit) {
        return new Memory(peer, limit);
    }

    public void setByte(long offset, byte b) {
        this.checkPosition(offset);
        this.setByteUnsafe(offset, b);
    }

    void setByteUnsafe(long offset, byte b) {
        unsafe.putByte(this.peer + offset, b);
    }

    public void setMemory(long offset, long bytes, byte b) {
        this.checkPosition(offset + bytes - 1L);
        unsafe.setMemory(this.peer + offset, bytes, b);
    }

    void copyMemory(long offset, long dstAddr, long bytes) {
        if (bytes > this.size - offset) {
            throw new IllegalArgumentException();
        }
        unsafe.copyMemory(this.peer + offset, dstAddr, bytes);
    }

    public void setLong(long offset, long l) {
        this.checkPosition(offset);
        unsafe.putLong(this.peer + offset, l);
    }

    public void setBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || bufferOffset + count > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        while (memoryOffset < end) {
            unsafe.putByte(this.peer + memoryOffset, buffer[bufferOffset]);
            ++memoryOffset;
            ++bufferOffset;
        }
    }

    public void setBytes(long memoryOffset, ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.remaining() == 0) {
            return;
        }
        int bufferOffset = buffer.position();
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)buffer.remaining();
        this.checkPosition(end - 1L);
        while (memoryOffset < end) {
            unsafe.putByte(this.peer + memoryOffset, buffer.get(bufferOffset));
            ++memoryOffset;
            ++bufferOffset;
        }
    }

    public byte getByte(long offset) {
        this.checkPosition(offset);
        return this.getByteUnsafe(offset);
    }

    byte getByteUnsafe(long offset) {
        return unsafe.getByte(this.peer + offset);
    }

    public long getLong(long offset) {
        this.checkPosition(offset);
        return unsafe.getLong(this.peer + offset);
    }

    public void getBytes(long memoryOffset, byte[] buffer, int bufferOffset, int count) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (bufferOffset < 0 || count < 0 || count > buffer.length - bufferOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (count == 0) {
            return;
        }
        this.checkPosition(memoryOffset);
        long end = memoryOffset + (long)count;
        this.checkPosition(end - 1L);
        while (memoryOffset < end) {
            buffer[bufferOffset++] = unsafe.getByte(this.peer + memoryOffset);
            ++memoryOffset;
        }
    }

    private void checkPosition(long offset) {
        assert (this.peer != 0L) : "Memory was freed";
        assert (offset >= 0L && offset < this.size) : "Illegal offset: " + offset + ", size: " + this.size;
    }

    public long getPeer() {
        return this.peer;
    }

    public Memory reallocate(int newSize) {
        this.peer = unsafe.reallocateMemory(this.peer, newSize);
        this.size = newSize;
        return this;
    }

    public void free() {
        assert (this.peer != 0L);
        unsafe.freeMemory(this.peer);
        this.peer = 0L;
    }

    public long size() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Memory)) {
            return false;
        }
        Memory b = (Memory)o;
        return this.peer == b.peer && this.size == b.size;
    }

    public String toString() {
        return new String(this.toBytes());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toBytes(), enc);
    }

    public byte[] toBytes() {
        return this.toBytes((int)this.size);
    }

    public byte[] toBytes(int size) {
        assert (size <= (int)this.size);
        byte[] buf = new byte[size];
        for (int i = 0; i < size; ++i) {
            buf[i] = this.getByte(i);
        }
        return buf;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buffer = new Pointer(this.peer).getByteBuffer(0L, this.size);
        if (buffer != null) {
            return buffer;
        }
        buffer = ByteBuffer.allocate((int)this.size);
        int i = 0;
        while ((long)i < this.size) {
            buffer.put(this.getByteUnsafe(i));
            ++i;
        }
        buffer.flip();
        return buffer;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

