/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.mysqlsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelMysqlsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_CONF = "camel.kamelet.mysql-source.serverName";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_DOC = "The server name for the data source. Example: localhost";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_CONF = "camel.kamelet.mysql-source.serverPort";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_DOC = "The server port for the data source.";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_DEFAULT = "3306";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_CONF = "camel.kamelet.mysql-source.username";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_DOC = "The username to access a secured MySQL Database.";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_CONF = "camel.kamelet.mysql-source.password";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_DOC = "The password to access a secured MySQL Database.";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_CONF = "camel.kamelet.mysql-source.query";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_DOC = "The query to execute against the MySQL Database. Example: INSERT INTO accounts (username,city) VALUES (:#username,:#city)";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_CONF = "camel.kamelet.mysql-source.databaseName";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_DOC = "The name of the MySQL Database.";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_CONF = "camel.kamelet.mysql-source.consumedQuery";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_DOC = "A query to run on a tuple consumed. Example: DELETE FROM accounts where user_id = :#user_id";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_CONF = "camel.kamelet.mysql-source.delay";
    public static final String CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_DOC = "The number of milliseconds before the next poll";
    public static final Integer CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_DEFAULT = 500;

    public CamelMysqlsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelMysqlsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_NAME_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_SERVER_PORT_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_QUERY_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DATABASE_NAME_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_CONSUMED_QUERY_DOC);
        conf.define(CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_MYSQLSOURCE_KAMELET_DELAY_DOC);
        return conf;
    }
}