/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.awscloudtrailsource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAwscloudtrailsourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_CONF = "camel.kamelet.aws-cloudtrail-source.accessKey";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_DOC = "The access key obtained from AWS.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_CONF = "camel.kamelet.aws-cloudtrail-source.secretKey";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_DOC = "The secret key obtained from AWS.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_CONF = "camel.kamelet.aws-cloudtrail-source.region";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_DOC = "The AWS region to access.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF = "camel.kamelet.aws-cloudtrail-source.useDefaultCredentialsProvider";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC = "If true, the Cloudtrail client loads credentials through a default credentials provider. If false, it uses the basic authentication method (access key and secret key).";
    public static final Boolean CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_CONF = "camel.kamelet.aws-cloudtrail-source.useProfileCredentialsProvider";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_DOC = "Set whether the Cloudtrail client should expect to load credentials through a profile credentials provider.";
    public static final Boolean CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_CONF = "camel.kamelet.aws-cloudtrail-source.useSessionCredentials";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_DOC = "Set whether the CloudTrail client should expect to use Session Credentials. This is useful in situation in which the user needs to assume a IAM role for doing operations in CloudTrail.";
    public static final Boolean CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_CONF = "camel.kamelet.aws-cloudtrail-source.profileCredentialsName";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_DOC = "If using a profile credentials provider this parameter will set the profile name.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_CONF = "camel.kamelet.aws-cloudtrail-source.sessionToken";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_DOC = "Amazon AWS Session Token used when the user needs to assume a IAM role.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_CONF = "camel.kamelet.aws-cloudtrail-source.uriEndpointOverride";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DOC = "The overriding endpoint URI. To use this option, you must also select the `overrideEndpoint` option.";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_CONF = "camel.kamelet.aws-cloudtrail-source.overrideEndpoint";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_DOC = "Select this option to override the endpoint URI. To use this option, you must also provide a URI for the `uriEndpointOverride` option.";
    public static final Boolean CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_CONF = "camel.kamelet.aws-cloudtrail-source.maxResults";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_DOC = "Maximum number of records that will be fetched in each poll.";
    public static final Integer CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_CONF = "camel.kamelet.aws-cloudtrail-source.eventSource";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_DOC = "Specify an event source to select events. Example: secretsmanager.amazonaws.com";
    public static final String CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_DEFAULT = null;

    public CamelAwscloudtrailsourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAwscloudtrailsourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SECRET_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_REGION_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_DEFAULT_CREDENTIALS_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_PROFILE_CREDENTIALS_PROVIDER_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_USE_SESSION_CREDENTIALS_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_PROFILE_CREDENTIALS_NAME_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_SESSION_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_URI_ENDPOINT_OVERRIDE_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_OVERRIDE_ENDPOINT_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_MAX_RESULTS_DOC);
        conf.define(CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSCLOUDTRAILSOURCE_KAMELET_EVENT_SOURCE_DOC);
        return conf;
    }
}