/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.CinderBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.volumes.cinder.SecretRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsType", "readOnly", "secretRef", "volumeID"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Cinder
implements Editable<CinderBuilder>,
KubernetesResource {
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type to mount.\nMust be a filesystem type supported by the host operating system.\nExamples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.\nMore info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly defaults to false (read/write). ReadOnly here will force\nthe ReadOnly setting in VolumeMounts.\nMore info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @JsonPropertyDescription(value="secretRef is optional: points to a secret object containing parameters used to connect\nto OpenStack.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="volumeID")
    @Required
    @JsonPropertyDescription(value="volumeID used to identify the volume in cinder.\nMore info: https://examples.k8s.io/mysql-cinder-pd/README.md")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeID;

    public CinderBuilder edit() {
        return new CinderBuilder(this);
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public String toString() {
        return "Cinder(fsType=" + this.getFsType() + ", readOnly=" + this.getReadOnly() + ", secretRef=" + this.getSecretRef() + ", volumeID=" + this.getVolumeID() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cinder)) {
            return false;
        }
        Cinder other = (Cinder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        SecretRef this$secretRef = this.getSecretRef();
        SecretRef other$secretRef = other.getSecretRef();
        if (this$secretRef == null ? other$secretRef != null : !((Object)this$secretRef).equals(other$secretRef)) {
            return false;
        }
        String this$volumeID = this.getVolumeID();
        String other$volumeID = other.getVolumeID();
        return !(this$volumeID == null ? other$volumeID != null : !this$volumeID.equals(other$volumeID));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cinder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        SecretRef $secretRef = this.getSecretRef();
        result = result * 59 + ($secretRef == null ? 43 : ((Object)$secretRef).hashCode());
        String $volumeID = this.getVolumeID();
        result = result * 59 + ($volumeID == null ? 43 : $volumeID.hashCode());
        return result;
    }
}

