/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.buildspec.tasks.S2i;
import org.apache.camel.v1.buildspec.tasks.s2i.Configuration;
import org.apache.camel.v1.buildspec.tasks.s2i.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.tasks.s2i.ConfigurationFluent;

public class S2iFluent<A extends S2iFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private String contextDir;
    private String name;
    private String tag;

    public S2iFluent() {
    }

    public S2iFluent(S2i instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(S2i instance) {
        S2i s2i = instance = instance != null ? instance : new S2i();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withContextDir(instance.getContextDir());
            this.withName(instance.getName());
            this.withTag(instance.getTag());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public String getContextDir() {
        return this.contextDir;
    }

    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)((Object)this);
    }

    public boolean hasContextDir() {
        return this.contextDir != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag = tag;
        return (A)((Object)this);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        S2iFluent that = (S2iFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.contextDir, that.contextDir)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.contextDir, this.name, this.tag, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.contextDir != null) {
            sb.append("contextDir:");
            sb.append(this.contextDir + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)S2iFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

