/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Process documents using Docling library for parsing and conversion.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DoclingEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Docling component.
     */
    public interface DoclingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDoclingEndpointBuilder advanced() {
            return (AdvancedDoclingEndpointBuilder) this;
        }

        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder contentInBody(boolean contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
        /**
         * Include the content of the output file in the exchange body and
         * delete the output file.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param contentInBody the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder contentInBody(String contentInBody) {
            doSetProperty("contentInBody", contentInBody);
            return this;
        }
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder enableOCR(boolean enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
        /**
         * Enable OCR processing for scanned documents.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param enableOCR the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder enableOCR(String enableOCR) {
            doSetProperty("enableOCR", enableOCR);
            return this;
        }
        /**
         * Show layout information with bounding boxes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeLayoutInfo(boolean includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
        /**
         * Show layout information with bounding boxes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param includeLayoutInfo the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder includeLayoutInfo(String includeLayoutInfo) {
            doSetProperty("includeLayoutInfo", includeLayoutInfo);
            return this;
        }
        /**
         * Language code for OCR processing.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: en
         * Group: producer
         * 
         * @param ocrLanguage the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder ocrLanguage(String ocrLanguage) {
            doSetProperty("ocrLanguage", ocrLanguage);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.docling.DoclingOperations</code>
         * type.
         * 
         * Required: true
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder operation(org.apache.camel.component.docling.DoclingOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.docling.DoclingOperations</code>
         * type.
         * 
         * Required: true
         * Default: CONVERT_TO_MARKDOWN
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Output format for document conversion.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: markdown
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder outputFormat(String outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder maxFileSize(long maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
        /**
         * Maximum file size in bytes for processing.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 52428800
         * Group: security
         * 
         * @param maxFileSize the value to set
         * @return the dsl builder
         */
        default DoclingEndpointBuilder maxFileSize(String maxFileSize) {
            doSetProperty("maxFileSize", maxFileSize);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Docling component.
     */
    public interface AdvancedDoclingEndpointBuilder
            extends
                EndpointProducerBuilder {
        default DoclingEndpointBuilder basic() {
            return (DoclingEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Path to Docling Python executable or command.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param doclingCommand the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder doclingCommand(String doclingCommand) {
            doSetProperty("doclingCommand", doclingCommand);
            return this;
        }
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder processTimeout(long processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
        /**
         * Timeout for Docling process execution in milliseconds.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param processTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder processTimeout(String processTimeout) {
            doSetProperty("processTimeout", processTimeout);
            return this;
        }
        /**
         * Working directory for Docling execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param workingDirectory the value to set
         * @return the dsl builder
         */
        default AdvancedDoclingEndpointBuilder workingDirectory(String workingDirectory) {
            doSetProperty("workingDirectory", workingDirectory);
            return this;
        }
    }

    public interface DoclingBuilders {
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * @return the dsl builder for the headers' name.
         */
        default DoclingHeaderNameBuilder docling() {
            return DoclingHeaderNameBuilder.INSTANCE;
        }
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * Syntax: <code>docling:operationId</code>
         * 
         * Path parameter: operationId (required)
         * The operation identifier
         * 
         * @param path operationId
         * @return the dsl builder
         */
        default DoclingEndpointBuilder docling(String path) {
            return DoclingEndpointBuilderFactory.endpointBuilder("docling", path);
        }
        /**
         * Docling (camel-docling)
         * Process documents using Docling library for parsing and conversion.
         * 
         * Category: transformation,ai
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-docling
         * 
         * Syntax: <code>docling:operationId</code>
         * 
         * Path parameter: operationId (required)
         * The operation identifier
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operationId
         * @return the dsl builder
         */
        default DoclingEndpointBuilder docling(String componentName, String path) {
            return DoclingEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Docling component.
     */
    public static class DoclingHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DoclingHeaderNameBuilder INSTANCE = new DoclingHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code DoclingOperations} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOperation}.
         */
        public String doclingOperation() {
            return "CamelDoclingOperation";
        }
        /**
         * The output format for conversion.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOutputFormat}.
         */
        public String doclingOutputFormat() {
            return "CamelDoclingOutputFormat";
        }
        /**
         * The input file path or content.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingInputFilePath}.
         */
        public String doclingInputFilePath() {
            return "CamelDoclingInputFilePath";
        }
        /**
         * The output file path for saving result.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOutputFilePath}.
         */
        public String doclingOutputFilePath() {
            return "CamelDoclingOutputFilePath";
        }
        /**
         * Additional processing options.
         * 
         * The option is a: {@code Map<String, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingProcessingOptions}.
         */
        public String doclingProcessingOptions() {
            return "CamelDoclingProcessingOptions";
        }
        /**
         * Whether to include OCR processing.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingEnableOCR}.
         */
        public String doclingEnableOCR() {
            return "CamelDoclingEnableOCR";
        }
        /**
         * Language for OCR processing.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingOCRLanguage}.
         */
        public String doclingOCRLanguage() {
            return "CamelDoclingOCRLanguage";
        }
        /**
         * Custom command line arguments to pass to Docling.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DoclingCustomArguments}.
         */
        public String doclingCustomArguments() {
            return "CamelDoclingCustomArguments";
        }
    }
    static DoclingEndpointBuilder endpointBuilder(String componentName, String path) {
        class DoclingEndpointBuilderImpl extends AbstractEndpointBuilder implements DoclingEndpointBuilder, AdvancedDoclingEndpointBuilder {
            public DoclingEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DoclingEndpointBuilderImpl(path);
    }
}