/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.language.groovy;

import java.util.Collections;
import java.util.Map;

import groovy.lang.GroovyShell;
import org.apache.camel.Exchange;

public interface GroovyShellFactory {

    GroovyShell createGroovyShell(Exchange exchange);

    default String getFileName(Exchange exchange) {
        return null;
    }

    /**
     * This method provide a way to define some global variables that will be applied to all the groovy script context.
     *
     * @param  exchange the camel exchange in process.
     * @return          the global variables that will be applied to all the groovy script context.
     */
    default Map<String, Object> getVariables(Exchange exchange) {
        return Collections.emptyMap();
    }
}
