/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang.coerce;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.brooklyn.util.exceptions.CompoundRuntimeException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.ClassCoercionException;
import org.apache.brooklyn.util.javalang.coerce.EnumTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.PrimitiveStringTypeCoercions;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.javalang.coerce.TypeCoercerExtensible;
import org.apache.brooklyn.util.text.Strings;

public class CommonAdaptorTryCoercions {
    private final TypeCoercerExtensible coercer;

    public CommonAdaptorTryCoercions(TypeCoercerExtensible coercer) {
        this.coercer = coercer;
    }

    public CommonAdaptorTryCoercions registerAllAdapters() {
        this.registerAdapter("11-with-from-method", new TryCoercerWithFromMethod());
        this.registerAdapter("12-enum", new TryCoercerToEnum());
        this.registerAdapter("13-toArray", new TryCoercerToArray(this.coercer));
        this.registerAdapter("15-primitives", new TryCoercerForPrimitivesAndStrings());
        return this;
    }

    public synchronized void registerAdapter(String nameAndOrder, TryCoercer fn) {
        this.coercer.registerAdapter(nameAndOrder, fn);
    }

    protected static class TryCoercerForPrimitivesAndStrings
    implements TryCoercer {
        protected TryCoercerForPrimitivesAndStrings() {
        }

        @Override
        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetType) {
            return PrimitiveStringTypeCoercions.tryCoerce(input, TypeTokens.getRawType(targetType, null));
        }
    }

    protected static class TryCoercerToArray
    implements TryCoercer {
        private final TypeCoercerExtensible coercer;

        public TryCoercerToArray(TypeCoercerExtensible coercer) {
            this.coercer = coercer;
        }

        @Override
        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetType) {
            Iterable<Object> castInput;
            if (!TypeTokens.isArray(targetType)) {
                return null;
            }
            TypeToken<?> targetComponentType = TypeTokens.getComponentType(targetType);
            if (input.getClass().isArray()) {
                castInput = Reflections.arrayToList(input);
            } else if (Iterable.class.isAssignableFrom(input.getClass())) {
                castInput = (Iterable)input;
            } else {
                return null;
            }
            Object result = Array.newInstance(TypeTokens.getRawType(targetComponentType, null), Iterables.size(castInput));
            int index = 0;
            for (Object member : castInput) {
                Maybe<?> coercedMember = this.coercer.tryCoerce(member, targetComponentType);
                if (coercedMember == null || coercedMember.isAbsent()) {
                    RuntimeException cause = Maybe.Absent.getException(coercedMember);
                    return Maybe.absent("Array member at index " + index + " cannot be coerced to " + targetComponentType, cause);
                }
                Array.set(result, index++, coercedMember.get());
            }
            return Maybe.of(result);
        }
    }

    protected static class TryCoercerToEnum
    implements TryCoercer {
        protected TryCoercerToEnum() {
        }

        @Override
        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetType) {
            Class rawTargetType = TypeTokens.getRawType(targetType, null);
            if (rawTargetType.isEnum()) {
                return EnumTypeCoercions.tryCoerceUntyped(Strings.toString(input), rawTargetType);
            }
            return null;
        }
    }

    protected static class TryCoercerWithFromMethod
    implements TryCoercer {
        protected TryCoercerWithFromMethod() {
        }

        @Override
        public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> targetType) {
            Class rawTargetType = TypeTokens.getRawType(targetType, null);
            ArrayList exceptions = Lists.newArrayList();
            for (Method m : rawTargetType.getMethods()) {
                if ((m.getModifiers() & 8) != 8 || !m.getName().startsWith("from") || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isInstance(input) || !m.getName().equals("from" + JavaClassNames.verySimpleClassName(m.getParameterTypes()[0]))) continue;
                try {
                    return Maybe.of(m.invoke(null, input));
                }
                catch (Exception e) {
                    exceptions.add(new ClassCoercionException("Cannot coerce type " + input.getClass() + " to " + rawTargetType.getCanonicalName() + " (" + input + "): " + m.getName() + " adapting failed", e));
                }
            }
            if (exceptions.isEmpty()) {
                return null;
            }
            if (exceptions.size() == 1) {
                return Maybe.absent((Throwable)exceptions.get(0));
            }
            String errMsg = "Failed coercing type " + input.getClass() + " to " + rawTargetType.getCanonicalName();
            return Maybe.absent(new CompoundRuntimeException(errMsg, exceptions));
        }
    }
}

