/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.hive.v1.SecretMapping;
import io.fabric8.openshift.api.model.hive.v1.SecretMappingBuilder;
import io.fabric8.openshift.api.model.hive.v1.SecretMappingFluent;
import io.fabric8.openshift.api.model.hive.v1.SelectorSyncSetSpec;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatchBuilder;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatchFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SelectorSyncSetSpecFluent<A extends SelectorSyncSetSpecFluent<A>>
extends BaseFluent<A> {
    private String applyBehavior;
    private LabelSelectorBuilder clusterDeploymentSelector;
    private ArrayList<SyncObjectPatchBuilder> patches = new ArrayList();
    private String resourceApplyMode;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    private ArrayList<SecretMappingBuilder> secretMappings = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SelectorSyncSetSpecFluent() {
    }

    public SelectorSyncSetSpecFluent(SelectorSyncSetSpec instance) {
        SelectorSyncSetSpec selectorSyncSetSpec = instance = instance != null ? instance : new SelectorSyncSetSpec();
        if (instance != null) {
            this.withApplyBehavior(instance.getApplyBehavior());
            this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
            this.withPatches(instance.getPatches());
            this.withResourceApplyMode(instance.getResourceApplyMode());
            this.withResources(instance.getResources());
            this.withSecretMappings(instance.getSecretMappings());
            this.withApplyBehavior(instance.getApplyBehavior());
            this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
            this.withPatches(instance.getPatches());
            this.withResourceApplyMode(instance.getResourceApplyMode());
            this.withResources(instance.getResources());
            this.withSecretMappings(instance.getSecretMappings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApplyBehavior() {
        return this.applyBehavior;
    }

    public A withApplyBehavior(String applyBehavior) {
        this.applyBehavior = applyBehavior;
        return (A)((Object)this);
    }

    public boolean hasApplyBehavior() {
        return this.applyBehavior != null;
    }

    public LabelSelector buildClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null ? this.clusterDeploymentSelector.build() : null;
    }

    public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
        this._visitables.get((Object)"clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
        if (clusterDeploymentSelector != null) {
            this.clusterDeploymentSelector = new LabelSelectorBuilder(clusterDeploymentSelector);
            this._visitables.get((Object)"clusterDeploymentSelector").add(this.clusterDeploymentSelector);
        } else {
            this.clusterDeploymentSelector = null;
            this._visitables.get((Object)"clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null;
    }

    public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
        return new ClusterDeploymentSelectorNested(null);
    }

    public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
        return new ClusterDeploymentSelectorNested(item);
    }

    public ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(null));
    }

    public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(item));
    }

    public A addToPatches(int index, SyncObjectPatch item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
        if (index < 0 || index >= this.patches.size()) {
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        } else {
            this._visitables.get((Object)"patches").add(index, builder);
            this.patches.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPatches(int index, SyncObjectPatch item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
        if (index < 0 || index >= this.patches.size()) {
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        } else {
            this._visitables.get((Object)"patches").set(index, builder);
            this.patches.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPatches(SyncObjectPatch ... items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPatches(Collection<SyncObjectPatch> items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPatches(SyncObjectPatch ... items) {
        if (this.patches == null) {
            return (A)((Object)this);
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").remove((Object)builder);
            this.patches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPatches(Collection<SyncObjectPatch> items) {
        if (this.patches == null) {
            return (A)((Object)this);
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").remove((Object)builder);
            this.patches.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPatches(Predicate<SyncObjectPatchBuilder> predicate) {
        if (this.patches == null) {
            return (A)((Object)this);
        }
        Iterator<SyncObjectPatchBuilder> each = this.patches.iterator();
        List visitables = this._visitables.get((Object)"patches");
        while (each.hasNext()) {
            SyncObjectPatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SyncObjectPatch> buildPatches() {
        return this.patches != null ? SelectorSyncSetSpecFluent.build(this.patches) : null;
    }

    public SyncObjectPatch buildPatch(int index) {
        return this.patches.get(index).build();
    }

    public SyncObjectPatch buildFirstPatch() {
        return this.patches.get(0).build();
    }

    public SyncObjectPatch buildLastPatch() {
        return this.patches.get(this.patches.size() - 1).build();
    }

    public SyncObjectPatch buildMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        for (SyncObjectPatchBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        for (SyncObjectPatchBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPatches(List<SyncObjectPatch> patches) {
        if (this.patches != null) {
            this._visitables.get((Object)"patches").clear();
        }
        if (patches != null) {
            this.patches = new ArrayList();
            for (SyncObjectPatch item : patches) {
                this.addToPatches(item);
            }
        } else {
            this.patches = null;
        }
        return (A)((Object)this);
    }

    public A withPatches(SyncObjectPatch ... patches) {
        if (this.patches != null) {
            this.patches.clear();
            this._visitables.remove((Object)"patches");
        }
        if (patches != null) {
            for (SyncObjectPatch item : patches) {
                this.addToPatches(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPatches() {
        return this.patches != null && !this.patches.isEmpty();
    }

    public PatchesNested<A> addNewPatch() {
        return new PatchesNested(-1, null);
    }

    public PatchesNested<A> addNewPatchLike(SyncObjectPatch item) {
        return new PatchesNested(-1, item);
    }

    public PatchesNested<A> setNewPatchLike(int index, SyncObjectPatch item) {
        return new PatchesNested(index, item);
    }

    public PatchesNested<A> editPatch(int index) {
        if (this.patches.size() <= index) {
            throw new RuntimeException("Can't edit patches. Index exceeds size.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public PatchesNested<A> editFirstPatch() {
        if (this.patches.size() == 0) {
            throw new RuntimeException("Can't edit first patches. The list is empty.");
        }
        return this.setNewPatchLike(0, this.buildPatch(0));
    }

    public PatchesNested<A> editLastPatch() {
        int index = this.patches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last patches. The list is empty.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public PatchesNested<A> editMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.patches.size(); ++i) {
            if (!predicate.test(this.patches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching patches. No match found.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    public String getResourceApplyMode() {
        return this.resourceApplyMode;
    }

    public A withResourceApplyMode(String resourceApplyMode) {
        this.resourceApplyMode = resourceApplyMode;
        return (A)((Object)this);
    }

    public boolean hasResourceApplyMode() {
        return this.resourceApplyMode != null;
    }

    public A addToResources(int index, Map<String, Object> item) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        this.resources.add(index, item);
        return (A)((Object)this);
    }

    public A setToResources(int index, Map<String, Object> item) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        this.resources.set(index, item);
        return (A)((Object)this);
    }

    public A addToResources(Map<String, Object> ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToResources(Collection<Map<String, Object>> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.resources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromResources(Map<String, Object> ... items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResources(Collection<Map<String, Object>> items) {
        if (this.resources == null) {
            return (A)((Object)this);
        }
        for (Map<String, Object> item : items) {
            this.resources.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    public Map<String, Object> getResource(int index) {
        return this.resources.get(index);
    }

    public Map<String, Object> getFirstResource() {
        return this.resources.get(0);
    }

    public Map<String, Object> getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public Map<String, Object> getMatchingResource(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public <K, V> A withResources(List<Map<String, Object>> resources) {
        if (resources != null) {
            this.resources = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)((Object)this);
    }

    public A withResources(Map<String, Object> ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove((Object)"resources");
        }
        if (resources != null) {
            for (Map<String, Object> item : resources) {
                this.addToResources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public A addToSecretMappings(int index, SecretMapping item) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        SecretMappingBuilder builder = new SecretMappingBuilder(item);
        if (index < 0 || index >= this.secretMappings.size()) {
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        } else {
            this._visitables.get((Object)"secretMappings").add(index, builder);
            this.secretMappings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecretMappings(int index, SecretMapping item) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        SecretMappingBuilder builder = new SecretMappingBuilder(item);
        if (index < 0 || index >= this.secretMappings.size()) {
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        } else {
            this._visitables.get((Object)"secretMappings").set(index, builder);
            this.secretMappings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecretMappings(SecretMapping ... items) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecretMappings(Collection<SecretMapping> items) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecretMappings(SecretMapping ... items) {
        if (this.secretMappings == null) {
            return (A)((Object)this);
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").remove((Object)builder);
            this.secretMappings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecretMappings(Collection<SecretMapping> items) {
        if (this.secretMappings == null) {
            return (A)((Object)this);
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").remove((Object)builder);
            this.secretMappings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecretMappings(Predicate<SecretMappingBuilder> predicate) {
        if (this.secretMappings == null) {
            return (A)((Object)this);
        }
        Iterator<SecretMappingBuilder> each = this.secretMappings.iterator();
        List visitables = this._visitables.get((Object)"secretMappings");
        while (each.hasNext()) {
            SecretMappingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<SecretMapping> buildSecretMappings() {
        return this.secretMappings != null ? SelectorSyncSetSpecFluent.build(this.secretMappings) : null;
    }

    public SecretMapping buildSecretMapping(int index) {
        return this.secretMappings.get(index).build();
    }

    public SecretMapping buildFirstSecretMapping() {
        return this.secretMappings.get(0).build();
    }

    public SecretMapping buildLastSecretMapping() {
        return this.secretMappings.get(this.secretMappings.size() - 1).build();
    }

    public SecretMapping buildMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        for (SecretMappingBuilder item : this.secretMappings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        for (SecretMappingBuilder item : this.secretMappings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecretMappings(List<SecretMapping> secretMappings) {
        if (this.secretMappings != null) {
            this._visitables.get((Object)"secretMappings").clear();
        }
        if (secretMappings != null) {
            this.secretMappings = new ArrayList();
            for (SecretMapping item : secretMappings) {
                this.addToSecretMappings(item);
            }
        } else {
            this.secretMappings = null;
        }
        return (A)((Object)this);
    }

    public A withSecretMappings(SecretMapping ... secretMappings) {
        if (this.secretMappings != null) {
            this.secretMappings.clear();
            this._visitables.remove((Object)"secretMappings");
        }
        if (secretMappings != null) {
            for (SecretMapping item : secretMappings) {
                this.addToSecretMappings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSecretMappings() {
        return this.secretMappings != null && !this.secretMappings.isEmpty();
    }

    public SecretMappingsNested<A> addNewSecretMapping() {
        return new SecretMappingsNested(-1, null);
    }

    public SecretMappingsNested<A> addNewSecretMappingLike(SecretMapping item) {
        return new SecretMappingsNested(-1, item);
    }

    public SecretMappingsNested<A> setNewSecretMappingLike(int index, SecretMapping item) {
        return new SecretMappingsNested(index, item);
    }

    public SecretMappingsNested<A> editSecretMapping(int index) {
        if (this.secretMappings.size() <= index) {
            throw new RuntimeException("Can't edit secretMappings. Index exceeds size.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    public SecretMappingsNested<A> editFirstSecretMapping() {
        if (this.secretMappings.size() == 0) {
            throw new RuntimeException("Can't edit first secretMappings. The list is empty.");
        }
        return this.setNewSecretMappingLike(0, this.buildSecretMapping(0));
    }

    public SecretMappingsNested<A> editLastSecretMapping() {
        int index = this.secretMappings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretMappings. The list is empty.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    public SecretMappingsNested<A> editMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretMappings.size(); ++i) {
            if (!predicate.test(this.secretMappings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretMappings. No match found.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectorSyncSetSpecFluent that = (SelectorSyncSetSpecFluent)((Object)o);
        if (!Objects.equals(this.applyBehavior, that.applyBehavior)) {
            return false;
        }
        if (!Objects.equals(this.clusterDeploymentSelector, that.clusterDeploymentSelector)) {
            return false;
        }
        if (!Objects.equals(this.patches, that.patches)) {
            return false;
        }
        if (!Objects.equals(this.resourceApplyMode, that.resourceApplyMode)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.secretMappings, that.secretMappings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.applyBehavior, this.clusterDeploymentSelector, this.patches, this.resourceApplyMode, this.resources, this.secretMappings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applyBehavior != null) {
            sb.append("applyBehavior:");
            sb.append(this.applyBehavior + ",");
        }
        if (this.clusterDeploymentSelector != null) {
            sb.append("clusterDeploymentSelector:");
            sb.append(this.clusterDeploymentSelector + ",");
        }
        if (this.patches != null && !this.patches.isEmpty()) {
            sb.append("patches:");
            sb.append(this.patches + ",");
        }
        if (this.resourceApplyMode != null) {
            sb.append("resourceApplyMode:");
            sb.append(this.resourceApplyMode + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.secretMappings != null && !this.secretMappings.isEmpty()) {
            sb.append("secretMappings:");
            sb.append(this.secretMappings + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretMappingsNested<N>
    extends SecretMappingFluent<SecretMappingsNested<N>>
    implements Nested<N> {
        SecretMappingBuilder builder;
        int index;

        SecretMappingsNested(int index, SecretMapping item) {
            this.index = index;
            this.builder = new SecretMappingBuilder(this, item);
        }

        public N and() {
            return (N)SelectorSyncSetSpecFluent.this.setToSecretMappings(this.index, this.builder.build());
        }

        public N endSecretMapping() {
            return this.and();
        }
    }

    public class PatchesNested<N>
    extends SyncObjectPatchFluent<PatchesNested<N>>
    implements Nested<N> {
        SyncObjectPatchBuilder builder;
        int index;

        PatchesNested(int index, SyncObjectPatch item) {
            this.index = index;
            this.builder = new SyncObjectPatchBuilder(this, item);
        }

        public N and() {
            return (N)SelectorSyncSetSpecFluent.this.setToPatches(this.index, this.builder.build());
        }

        public N endPatch() {
            return this.and();
        }
    }

    public class ClusterDeploymentSelectorNested<N>
    extends LabelSelectorFluent<ClusterDeploymentSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ClusterDeploymentSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)SelectorSyncSetSpecFluent.this.withClusterDeploymentSelector(this.builder.build());
        }

        public N endClusterDeploymentSelector() {
            return this.and();
        }
    }
}

