/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.security.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigMap;
import org.apache.brooklyn.config.StringConfigMap;
import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.rest.BrooklynWebConfig;
import org.apache.brooklyn.rest.security.provider.BlackholeSecurityProvider;
import org.apache.brooklyn.rest.security.provider.SecurityProvider;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingSecurityProvider
implements SecurityProvider {
    private static final Logger log = LoggerFactory.getLogger(DelegatingSecurityProvider.class);
    protected final ManagementContext mgmt;
    private SecurityProvider delegate;

    public DelegatingSecurityProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public synchronized SecurityProvider getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.loadDelegate();
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized SecurityProvider loadDelegate() {
        StringConfigMap brooklynProperties = this.mgmt.getConfig();
        SecurityProvider presetDelegate = (SecurityProvider)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE);
        if (presetDelegate != null) {
            log.trace("Brooklyn security: using pre-set security provider {}", (Object)presetDelegate);
            return presetDelegate;
        }
        String className = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_CLASSNAME);
        if (this.delegate != null && BrooklynWebConfig.hasNoSecurityOptions((ConfigMap)this.mgmt.getConfig())) {
            log.debug("Brooklyn security: {} refusing to change from {}: No security provider set in reloaded properties.", (Object)this, (Object)this.delegate);
            return this.delegate;
        }
        try {
            String bundle = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_BUNDLE);
            Class<DelegatingSecurityProvider> clazz = DelegatingSecurityProvider.class;
            synchronized (DelegatingSecurityProvider.class) {
                presetDelegate = (SecurityProvider)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE);
                if (presetDelegate != null) {
                    log.trace("Brooklyn security: using pre-set security provider, found late - {}", (Object)presetDelegate);
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return presetDelegate;
                }
                if (bundle != null) {
                    String bundleVersion = (String)brooklynProperties.getConfig(BrooklynWebConfig.SECURITY_PROVIDER_BUNDLE_VERSION);
                    log.info("Brooklyn security: using security provider " + className + " from " + bundle + ":" + bundleVersion);
                    BundleContext bundleContext = ((OsgiManager)((ManagementContextInternal)this.mgmt).getOsgiManager().get()).getFramework().getBundleContext();
                    this.delegate = DelegatingSecurityProvider.loadProviderFromBundle(this.mgmt, bundleContext, bundle, bundleVersion, className);
                    this.saveDelegate();
                } else {
                    log.info("Brooklyn security: using security provider " + className);
                    ClassLoaderUtils clu = new ClassLoaderUtils((Object)this, this.mgmt);
                    Class clazz2 = clu.loadClass(className);
                    this.delegate = DelegatingSecurityProvider.createSecurityProviderInstance(this.mgmt, clazz2);
                    this.saveDelegate();
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            log.warn("Brooklyn security: unable to instantiate security provider " + className + "; all logins are being disallowed", (Throwable)e);
            this.delegate = new BlackholeSecurityProvider();
        }
        {
            return this.delegate;
        }
    }

    private void saveDelegate() {
        ((BrooklynProperties)this.mgmt.getConfig()).put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)this.delegate);
        this.mgmt.getScratchpad().put(BrooklynWebConfig.SECURITY_PROVIDER_INSTANCE, (Object)this.delegate);
    }

    public static SecurityProvider loadProviderFromBundle(ManagementContext mgmt, BundleContext bundleContext, String symbolicName, String version, String className) {
        try {
            SecurityProvider p;
            Collection<Bundle> bundles = DelegatingSecurityProvider.getMatchingBundles(bundleContext, symbolicName, version);
            if (bundles.isEmpty()) {
                throw new IllegalStateException("No bundle " + symbolicName + ":" + version + " found");
            }
            if (bundles.size() > 1) {
                log.warn("Brooklyn security: found multiple bundles matching symbolicName " + symbolicName + " and version " + version + " while trying to load security provider " + className + ". Will use first one that loads the class successfully.");
            }
            if ((p = DelegatingSecurityProvider.tryLoadClass(mgmt, className, bundles)) == null) {
                throw new ClassNotFoundException("Unable to load class " + className + " from bundle " + symbolicName + ":" + version);
            }
            return p;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Can not load or create security provider " + className + " for bundle " + symbolicName + ":" + version, e);
        }
    }

    private static SecurityProvider tryLoadClass(ManagementContext mgmt, String className, Collection<Bundle> bundles) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        for (Bundle b : bundles) {
            try {
                Class securityProviderType = b.loadClass(className);
                return DelegatingSecurityProvider.createSecurityProviderInstance(mgmt, securityProviderType);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static Collection<Bundle> getMatchingBundles(BundleContext bundleContext, String symbolicName, String version) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        for (Bundle b : bundleContext.getBundles()) {
            if (!b.getSymbolicName().equals(symbolicName) || version != null && !b.getVersion().toString().equals(version)) continue;
            bundles.add(b);
        }
        return bundles;
    }

    public static SecurityProvider createSecurityProviderInstance(ManagementContext mgmt, Class<? extends SecurityProvider> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        SecurityProvider delegateO;
        Constructor<? extends SecurityProvider> constructor = null;
        try {
            constructor = clazz.getConstructor(ManagementContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor != null) {
            delegateO = constructor.newInstance(mgmt);
        } else {
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                delegateO = constructor.newInstance(new Object[0]);
            } else {
                throw new NoSuchMethodException("Security provider " + clazz + " does not have required no-arg or 1-arg (mgmt) constructor");
            }
        }
        if (!(delegateO instanceof SecurityProvider)) {
            throw new ClassCastException("Delegate is either not a security provider or has an incompatible classloader: " + delegateO);
        }
        return delegateO;
    }

    @Override
    public boolean isAuthenticated(HttpSession session) {
        return this.getDelegate().isAuthenticated(session);
    }

    @Override
    public boolean authenticate(HttpServletRequest request, Supplier<HttpSession> sessionSupplierOnSuccess, String user, String pass) throws SecurityProvider.SecurityProviderDeniedAuthentication {
        boolean authenticated = this.getDelegate().authenticate(request, sessionSupplierOnSuccess, user, pass);
        if (log.isTraceEnabled() && authenticated) {
            log.trace("User {} authenticated with provider {}", (Object)user, (Object)this.getDelegate());
        } else if (!authenticated && log.isDebugEnabled()) {
            log.debug("Failed authentication for user {} with provider {}", (Object)user, (Object)this.getDelegate());
        }
        return authenticated;
    }

    @Override
    public boolean logout(HttpSession session) {
        return this.getDelegate().logout(session);
    }

    @Override
    public boolean requiresUserPass() {
        return this.getDelegate().requiresUserPass();
    }

    public String toString() {
        return super.toString() + "[" + this.getDelegate() + "]";
    }
}

