/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.Effector;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.group.SequenceGroupImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.text.StringPredicates;

@ImplementedBy(value=SequenceGroupImpl.class)
public interface SequenceGroup
extends DynamicGroup {
    public static final AttributeSensor<Integer> SEQUENCE_VALUE = Sensors.builder(Integer.class, "sequence.value").description("The current value of the sequence").build();
    public static final AttributeSensor<String> SEQUENCE_STRING = Sensors.builder(String.class, "sequence.string").description("The current value of the sequence formatted as a string").build();
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKeyWithDefault(DynamicGroup.ENTITY_FILTER, Predicates.alwaysFalse());
    @SetFromFlag(value="sequenceStart")
    public static final ConfigKey<Integer> SEQUENCE_START = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Integer.class).name("sequence.start")).description("The starting point of the sequence")).defaultValue(1)).constraint(Predicates.notNull())).build();
    @SetFromFlag(value="sequenceIncrement")
    public static final ConfigKey<Integer> SEQUENCE_INCREMENT = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(Integer.class).name("sequence.increment")).description("The sequence increment for the next value")).defaultValue(1)).constraint(Predicates.notNull())).build();
    @SetFromFlag(value="sequenceFormat")
    public static final ConfigKey<String> SEQUENCE_FORMAT = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(String.class).name("sequence.format")).description("A format used to generate a string representation of the sequence")).defaultValue((String)"%d")).constraint(StringPredicates.containsRegex((String)"%[-#+ 0,(]*[0-9]*[doxX]"))).build();
    @SetFromFlag(value="sequenceValueSensor")
    public static final ConfigKey<AttributeSensor<Integer>> SEQUENCE_VALUE_SENSOR = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<AttributeSensor<Integer>>(){}).name("sequence.sensor.value")).description("The sensor for the sequence value")).defaultValue(SEQUENCE_VALUE)).constraint(Predicates.notNull())).build();
    @SetFromFlag(value="sequenceStringSensor")
    public static final ConfigKey<AttributeSensor<String>> SEQUENCE_STRING_SENSOR = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder(new TypeToken<AttributeSensor<String>>(){}).name("sequence.sensor.string")).description("The sensor for the sequence string")).defaultValue(SEQUENCE_STRING)).constraint(Predicates.notNull())).build();
    public static final AttributeSensor<Entity> SEQUENCE_CURRENT = Sensors.builder(Entity.class, "sequence.current").description("The current entity in the sequence").build();
    public static final AttributeSensor<AtomicInteger> SEQUENCE_STATE = Sensors.builder(AtomicInteger.class, "sequence.state").description("The current state of the sequence").build();
    public static final AttributeSensor<Map<String, Integer>> SEQUENCE_CACHE = Sensors.builder(new TypeToken<Map<String, Integer>>(){}, "sequence.cache").description("The current cache of entity ids to sequence numbers").build();
    public static final MethodEffector<Void> RESET = new MethodEffector(SequenceGroup.class, "reset");

    @Effector(description="Reset the sequence to initial value")
    public Void reset();
}

