/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.sensor.Feed;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonType;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsPropertyIfAmbiguous {
    private static final Logger LOG = LoggerFactory.getLogger(AsPropertyIfAmbiguous.class);
    private static Set<String> warnedAmbiguousTypeProperty = MutableSet.of();
    public static final Function<String, String> CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM = t -> "(" + t + ")";
    public static final Function<String, String> CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM_ALT = t -> CONFLICTING_TYPE_NAME_PROPERTY_PREFIX + t;
    public static final String CONFLICTING_TYPE_NAME_PROPERTY_PREFIX = "@";
    public static final boolean THROW_ON_OBJECT_EXPECTED_AND_INVALID_TYPE_KEY_SUPPLIED = true;
    static ThreadLocal<AtomicInteger> suppressingTypeFieldDeserialization = new ThreadLocal();

    static boolean isSuppressingTypeFieldDeserialization() {
        AtomicInteger count = suppressingTypeFieldDeserialization.get();
        if (count == null) {
            return false;
        }
        return count.get() > 0;
    }

    static void startSuppressingTypeFieldDeserialization() {
        AtomicInteger count = suppressingTypeFieldDeserialization.get();
        if (count == null) {
            count = new AtomicInteger();
            suppressingTypeFieldDeserialization.set(count);
        }
        count.incrementAndGet();
    }

    static void stopSuppressingTypeFieldDeserialization() {
        AtomicInteger count = suppressingTypeFieldDeserialization.get();
        if (count == null) {
            throw new IllegalStateException("Count mismatch starting/stopping type field deserialization");
        }
        if (count.decrementAndGet() == 0) {
            suppressingTypeFieldDeserialization.remove();
        }
    }

    public static class AsPropertyButNotIfFieldConflictTypeDeserializer
    extends AsPropertyTypeDeserializer {
        public AsPropertyButNotIfFieldConflictTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
            super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl, inclusion);
        }

        public AsPropertyButNotIfFieldConflictTypeDeserializer(AsPropertyButNotIfFieldConflictTypeDeserializer src, BeanProperty prop) {
            super((AsPropertyTypeDeserializer)src, prop);
        }

        public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return super.deserializeTypedFromArray(jp, ctxt);
        }

        AsPropertyButNotIfFieldConflictTypeDeserializer cloneWithNewTypePropertyName(String newTypePropertyName) {
            return new AsPropertyButNotIfFieldConflictTypeDeserializer(this._baseType, this._idResolver, newTypePropertyName, this._typeIdVisible, this._defaultImpl, this._inclusion);
        }

        protected boolean hasTypePropertyNameAsField(JavaType type) {
            return this.presentAndNotJsonIgnored((Maybe<? extends AccessibleObject>)Reflections.findFieldMaybe((Class)type.getRawClass(), (String)this._typePropertyName)) || this.presentAndNotJsonIgnored((Maybe<? extends AccessibleObject>)Reflections.findMethodMaybe((Class)type.getRawClass(), (String)("get" + Strings.toInitialCapOnly((String)this._typePropertyName)), (Class[])new Class[0]));
        }

        public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
            JavaType baseType;
            AsPropertyButNotIfFieldConflictTypeDeserializer target = this;
            boolean mustUseConflictingTypePrefix = false;
            if (this._idResolver instanceof HasBaseType && (baseType = ((HasBaseType)this._idResolver).getBaseType()) != null) {
                if (this.hasTypePropertyNameAsField(baseType) && !AbstractBrooklynObjectSpec.class.isAssignableFrom(baseType.getRawClass())) {
                    mustUseConflictingTypePrefix = true;
                }
                if (!Objects.equals(this._defaultImpl, baseType)) {
                    target = new AsPropertyButNotIfFieldConflictTypeDeserializer(this._baseType, this._idResolver, this._typePropertyName, this._typeIdVisible, ((HasBaseType)this._idResolver).getBaseType(), this._inclusion);
                }
            }
            return target.deserializeTypedFromObjectSuper(p, ctxt, mustUseConflictingTypePrefix);
        }

        private Object deserializeTypedFromObjectSuper(JsonParser p, DeserializationContext ctxt, boolean mustUseConflictingTypePrefix) throws IOException {
            Object typeId;
            if (AsPropertyIfAmbiguous.isSuppressingTypeFieldDeserialization()) {
                return this._deserializeTypedUsingDefaultImpl(p, ctxt, null, "typed deserialization is suppressed");
            }
            if (p.canReadTypeId() && (typeId = p.getTypeId()) != null) {
                return this._deserializeWithNativeTypeId(p, ctxt, typeId);
            }
            JsonToken t = p.currentToken();
            if (t == JsonToken.START_OBJECT) {
                t = p.nextToken();
            } else if (t != JsonToken.FIELD_NAME) {
                return this._deserializeTypedUsingDefaultImpl(p, ctxt, null, this._msgForMissingId);
            }
            TokenBuffer tb = null;
            boolean ignoreCase = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
            TokenBuffer tb0 = BrooklynJacksonSerializationUtils.createBufferForParserCurrentObject(p, ctxt);
            p = tb0.asParserOnFirstToken();
            DiscoveredTypeAndCachedTokenBuffer typeIdFindResult = this.findTypeIdOrUnambiguous(p, ctxt, t, tb, ignoreCase, mustUseConflictingTypePrefix);
            tb = typeIdFindResult.tb;
            IOException preferredError = null;
            Exception otherError = null;
            if (typeIdFindResult.type != null) {
                boolean canTryWithoutType = !typeIdFindResult.isUnambiguous;
                try {
                    Class rawClass;
                    JavaType baseType;
                    Object result = this._deserializeTypedForId(p, ctxt, tb, typeIdFindResult.type);
                    if (result == null) {
                        LOG.trace("Null result deserializing");
                    } else if (this._idResolver instanceof HasBaseType && (baseType = ((HasBaseType)this._idResolver).getBaseType()) != null && (rawClass = baseType.getRawClass()) != null && !rawClass.isAssignableFrom(result.getClass())) {
                        canTryWithoutType = true;
                        preferredError = new IOException("Invalid result: deserialized type " + result.getClass() + " when expected " + baseType);
                        throw preferredError;
                    }
                    return result;
                }
                catch (Exception e) {
                    if (!canTryWithoutType) {
                        throw e;
                    }
                    p = tb0.asParserOnFirstToken();
                    tb = tb0;
                    otherError = e;
                }
            }
            try {
                return this._deserializeTypedUsingDefaultImpl(p, ctxt, tb, this._msgForMissingId);
            }
            catch (Exception e2) {
                if (preferredError != null) {
                    throw preferredError;
                }
                if (otherError == null) {
                    throw e2;
                }
                throw Exceptions.propagate((String)("Cannot deserialize instance of " + (this._idResolver instanceof HasBaseType && ((HasBaseType)this._idResolver).getBaseType() != null ? this.baseTypeName() : "any object") + " declaring type '" + typeIdFindResult.type + "'"), (Iterable)MutableList.of((Object)otherError, (Object)e2));
            }
        }

        private DiscoveredTypeAndCachedTokenBuffer findTypeIdOrUnambiguous(JsonParser p, DeserializationContext ctxt, JsonToken t, TokenBuffer tb, boolean ignoreCase, boolean mustUseConflictingTypePrefix) throws IOException {
            if (this.baseType() != null && Map.class.isAssignableFrom(this.baseType().getRawClass())) {
                return new DiscoveredTypeAndCachedTokenBuffer(null, tb, false);
            }
            String typeUnambiguous1 = CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM.apply(this._typePropertyName);
            String typeUnambiguous2 = CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM_ALT.apply(this._typePropertyName);
            int fieldsRead = 0;
            while (t == JsonToken.FIELD_NAME) {
                String typeId;
                boolean ambiguousName;
                String name = p.currentName();
                p.nextToken();
                boolean unambiguousName = name.equals(typeUnambiguous1) || name.equals(typeUnambiguous2);
                boolean bl = ambiguousName = !unambiguousName && !mustUseConflictingTypePrefix && (name.equals(this._typePropertyName) || ignoreCase && name.equalsIgnoreCase(this._typePropertyName));
                if ((ambiguousName || unambiguousName) && (typeId = p.getValueAsString()) != null) {
                    boolean disallowed = false;
                    JavaType tt = null;
                    try {
                        tt = this._idResolver.typeFromId((DatabindContext)ctxt, typeId);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfInterrupt((Throwable)e);
                        throw Exceptions.propagate((Throwable)e);
                    }
                    if (ambiguousName && !disallowed) {
                        if (tt != null && BrooklynObject.class.isAssignableFrom(tt.getRawClass()) && !Feed.class.isAssignableFrom(tt.getRawClass())) {
                            Boolean wantsSpec = null;
                            Boolean wantsBO = null;
                            JavaType baseType = null;
                            if (this._idResolver instanceof HasBaseType && (baseType = ((HasBaseType)this._idResolver).getBaseType()) != null) {
                                wantsSpec = AbstractBrooklynObjectSpec.class.isAssignableFrom(baseType.getRawClass());
                                wantsBO = BrooklynObject.class.isAssignableFrom(baseType.getRawClass());
                            }
                            if (Boolean.TRUE.equals(wantsSpec)) {
                                if (!(tt instanceof BrooklynJacksonType) || !BrooklynTypeRegistry.RegisteredTypeKind.SPEC.equals((Object)((BrooklynJacksonType)tt).getRegisteredType().getKind())) {
                                    typeId = BrooklynObjectType.of((Class)tt.getRawClass()).getSpecType().getName();
                                    tt = null;
                                    if (tb == null) {
                                        tb = ctxt.bufferForInputBuffering(p);
                                    }
                                    tb.writeFieldName(name);
                                    tb.copyCurrentStructure(p);
                                }
                            } else if (!(Boolean.TRUE.equals(wantsBO) || !(tt instanceof BrooklynJacksonType) && BrooklynObjectType.of((Class)tt.getRawClass()).getInterfaceType().equals(tt.getRawClass()))) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Ambiguous request for " + baseType + " / " + tt + "; allowing");
                                }
                                tt = null;
                                disallowed = true;
                            }
                        }
                        if (tt != null && this.hasTypePropertyNameAsField(tt)) {
                            disallowed = true;
                            if (this._idResolver instanceof HasBaseType) {
                                JavaType baseType = ((HasBaseType)this._idResolver).getBaseType();
                                if (baseType == null || baseType.getRawClass().equals(Object.class)) {
                                    if (fieldsRead == 0) {
                                        if (warnedAmbiguousTypeProperty.add(typeId)) {
                                            LOG.warn("Ambiguous type property '" + this._typePropertyName + "' used for '" + typeId + "' as first entry in definition; this looks like a type specification but this could also refer to the property; using for the former, but specification should have used '" + typeUnambiguous1 + "' as key earlier in the map, or if setting the field is intended put an explicit '" + typeUnambiguous1 + "' before it");
                                        }
                                        disallowed = false;
                                    }
                                } else if (!baseType.isMapLikeType()) {
                                    if (warnedAmbiguousTypeProperty.add(typeId)) {
                                        LOG.warn("Ambiguous type property '" + this._typePropertyName + "' used for '" + typeId + "'; a type specification is needed to comply with expectations, but this could also refer to the property; using for the former, but specification should have used " + typeUnambiguous1 + " as key earlier in the map");
                                    }
                                    disallowed = false;
                                }
                            }
                        }
                    }
                    if (!disallowed) {
                        return new DiscoveredTypeAndCachedTokenBuffer(typeId, tb, unambiguousName);
                    }
                }
                if (tb == null) {
                    tb = ctxt.bufferForInputBuffering(p);
                }
                tb.writeFieldName(name);
                tb.copyCurrentStructure(p);
                ++fieldsRead;
                t = p.nextToken();
            }
            return new DiscoveredTypeAndCachedTokenBuffer(null, tb, true);
        }

        private boolean presentAndNotJsonIgnored(Maybe<? extends AccessibleObject> fm) {
            if (!fm.isPresent()) {
                return false;
            }
            AccessibleObject f = (AccessibleObject)fm.get();
            JsonIgnore ignored = f.getAnnotation(JsonIgnore.class);
            return ignored == null;
        }

        public TypeDeserializer forProperty(BeanProperty prop) {
            return prop == this._property ? this : new AsPropertyButNotIfFieldConflictTypeDeserializer(this, prop);
        }

        public Object deserializeArrayContainingType(JsonParser p, DeserializationContext ctxt) throws IOException {
            return super._deserialize(p, ctxt);
        }

        protected Object _deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            if (p.isExpectedStartArrayToken()) {
                String typeId = this._idResolver.idFromBaseType();
                JsonDeserializer deser = this._findDeserializer(ctxt, typeId);
                if (p.currentToken() == JsonToken.END_ARRAY) {
                    return deser.getEmptyValue(ctxt);
                }
                return deser.deserialize(p, ctxt);
            }
            return super._deserialize(p, ctxt);
        }

        protected Object _deserializeTypedForId(JsonParser p, DeserializationContext ctxt, TokenBuffer tb, String typeId) throws IOException {
            JsonDeserializer deser = this._findDeserializer(ctxt, typeId);
            if (this._typeIdVisible) {
                if (tb == null) {
                    tb = new TokenBuffer(p, ctxt);
                }
                tb.writeFieldName(p.getCurrentName());
                tb.writeString(typeId);
            }
            if (tb != null) {
                p.clearCurrentToken();
                p = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tb.asParser(p), (JsonParser)p);
            }
            if (p.currentToken() != JsonToken.END_OBJECT) {
                p.nextToken();
            }
            boolean wasEndToken = p.currentToken() == JsonToken.END_OBJECT;
            try {
                return deser.deserialize(p, ctxt);
            }
            catch (Exception e) {
                Object candidate;
                Exceptions.propagateIfFatal((Throwable)e);
                if (wasEndToken && (candidate = deser.getEmptyValue(ctxt)) != null) {
                    return candidate;
                }
                throw e;
            }
        }

        protected Object _deserializeTypedUsingDefaultImpl(JsonParser p, DeserializationContext ctxt, TokenBuffer tb, String priorFailureMsg) throws IOException {
            JsonDeserializer deserPeek = this._findDefaultImplDeserializer(ctxt);
            if (this.isAbstract(deserPeek) && p.getCurrentToken() == JsonToken.START_ARRAY) {
                return this.deserializeArrayContainingType(p, ctxt);
            }
            return super._deserializeTypedUsingDefaultImpl(p, ctxt, tb, priorFailureMsg);
        }

        protected boolean isAbstract(JsonDeserializer d) {
            if (d instanceof AbstractDeserializer) {
                return true;
            }
            if (d instanceof DelegatingDeserializer) {
                return this.isAbstract(((DelegatingDeserializer)d).getDelegatee());
            }
            return false;
        }

        static class DiscoveredTypeAndCachedTokenBuffer {
            String type;
            TokenBuffer tb;
            boolean isUnambiguous;

            DiscoveredTypeAndCachedTokenBuffer(String type, TokenBuffer tb, boolean isUnambiguous) {
                this.type = type;
                this.tb = tb;
                this.isUnambiguous = isUnambiguous;
            }
        }
    }

    public static class AsPropertyIfAmbiguousTypeSerializer
    extends AsPropertyTypeSerializer {
        public AsPropertyIfAmbiguousTypeSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
            super(idRes, property, propName);
        }

        public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
            Class<?> currentClass;
            boolean skip = false;
            Object currentObject = idMetadata.forValue;
            Class<?> clazz = currentClass = currentObject == null ? null : currentObject.getClass();
            if (this._idResolver instanceof HasBaseType) {
                Class impliedClass;
                JavaType impliedType = ((HasBaseType)this._idResolver).getBaseType();
                Class clazz2 = impliedClass = impliedType == null ? null : impliedType.getRawClass();
                if (Objects.equals(currentClass, impliedClass)) {
                    skip = true;
                }
                if (!skip && impliedClass != null) {
                    boolean bl = skip = impliedType.isCollectionLikeType() || Map.class.isAssignableFrom(impliedClass);
                }
                if (!skip && currentClass != null) {
                    boolean bl = skip = List.class.isAssignableFrom(currentClass) || Map.class.isAssignableFrom(currentClass) || currentClass.isArray();
                }
            }
            if (skip) {
                this._generateTypeId(idMetadata);
                if (idMetadata.valueShape == JsonToken.START_OBJECT) {
                    g.writeStartObject(idMetadata.forValue);
                } else if (idMetadata.valueShape == JsonToken.START_ARRAY) {
                    g.writeStartArray();
                }
                return idMetadata;
            }
            String tpn = idMetadata.asProperty;
            if (tpn == null) {
                tpn = this._typePropertyName;
            }
            if (currentClass != null && Reflections.findFieldMaybe(currentClass, (String)tpn).isPresent()) {
                idMetadata.asProperty = tpn = CONFLICTING_TYPE_NAME_PROPERTY_TRANSFORM.apply(tpn);
            }
            return super.writeTypePrefix(g, idMetadata);
        }

        public AsPropertyTypeSerializer forProperty(BeanProperty prop) {
            return this._property == prop ? this : new AsPropertyIfAmbiguousTypeSerializer(this._idResolver, prop, this._typePropertyName);
        }
    }

    public static interface HasBaseType {
        public JavaType getBaseType();
    }
}

